package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.PageParam;

import java.io.Serializable;
import java.util.Date;

/**
 * t_advert_position
 * @author 
 */
public class AdvertPosition extends PageParam implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 广告投放名称
     */
    private String advertName;

    /**
     * 是否上架（1：是，0：否）
     */
    private Integer enableStatus;

    /**
     * 投放位置类型,1：首页弹窗广告 2：个人中心随机广告  3：赚钱中心轮播广告 4：列表广告 5：赚钱中心公告 6：首页悬浮广告 7:开屏广告 8:首页配置广告 9:签到页面轮播广告 10:消息中心轮播广告 11:社区首页文字广告
     */
    private Integer positionType;

    /**
     * 是否全国投放（0：false，1：true）
     */
    private Integer globalStatus;

    /**
     * 开始投放时间
     */
    private Date startTime;

    /**
     * 结束投放时间
     */
    private Date endTime;

    /**
     * 展示方式：0默认展示，1新用户展示一次，2所有用户只展示1次，3每天第一次打开App时展示
     */
    private Integer showType;

    /**
     * 倒计时时间（特殊广告类型需要）
     */
    private Integer timeout;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 发布人
     */
    private Long creator;

    /**
     * 投放对象
     */
    private String deliveryObject;

    private static final long serialVersionUID = 1L;

    public String getDeliveryObject() {
        return deliveryObject;
    }

    public void setDeliveryObject(String deliveryObject) {
        this.deliveryObject = deliveryObject;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getPositionType() {
        return positionType;
    }

    public void setPositionType(Integer positionType) {
        this.positionType = positionType;
    }

    public Integer getGlobalStatus() {
        return globalStatus;
    }

    public void setGlobalStatus(Integer globalStatus) {
        this.globalStatus = globalStatus;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getShowType() {
        return showType;
    }

    public void setShowType(Integer showType) {
        this.showType = showType;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }
}