package com.bxm.localnews.admin.vo;

import java.io.Serializable;

/**
 * 区域划分实体
 * @author 
 */
public class AreaDivision implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * 区域编码
     */
    private String code;

    /**
     * 父级区域编码
     */
    private String parentCode;

    /**
     * 区域名称
     */
    private String name;

    /**
     * 区域全称（从上级一直到当前级别的名称）
     */
    private String fullName;

    /**
     * 是否可用（1表示可用，0表示不可用）
     */
    private Byte enable;

    /**
     * 区域级别（1：省、2：市、3：区、县）
     */
    private Byte level;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Byte getEnable() {
        return enable;
    }

    public void setEnable(Byte enable) {
        this.enable = enable;
    }

    public Byte getLevel() {
        return level;
    }

    public void setLevel(Byte level) {
        this.level = level;
    }
}