package com.bxm.localnews.admin.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.bxm.newidea.component.vo.BaseBean;

import io.swagger.annotations.ApiModelProperty;

public class BaseCommodityBean extends BaseBean {

    @ApiModelProperty("商品ID")
    private long id;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("商品类别，取值见商品类别字典")
    private String type;

    @ApiModelProperty("商品图片路径")
    private String imgUrl;

    @ApiModelProperty("商品原价")
    private BigDecimal originalCost;

    @ApiModelProperty("商品现价,默认为0")
    private BigDecimal currentPrice;

    @ApiModelProperty("商品所属商户ID")
    private long mechantId;

    @ApiModelProperty("商品上下架状态，0：下架，1：上架，默认为上架状态")
    private int status;

    @ApiModelProperty("库存数量")
    private int num;

    @ApiModelProperty("商品有效开始日期，默认当前时间")
    private Date startTime = new Date();

    @ApiModelProperty("商品有效截止日期,默认一年后")
    private Date endTime = new Date(System.currentTimeMillis() + 31536000000l);

    @ApiModelProperty("商品详情（图文混排）HTML")
    private String detail;

    @ApiModelProperty("商品性质：1.普通商品  2.VIP电影票赠送商品")
    private Byte category;

    public Byte getCategory() {
        return category;
    }

    public void setCategory(Byte category) {
        this.category = category;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BigDecimal getOriginalCost() {
        return originalCost;
    }

    public void setOriginalCost(BigDecimal originalCost) {
        this.originalCost = originalCost;
    }

    public BigDecimal getCurrentPrice() {
        return currentPrice;
    }

    public void setCurrentPrice(BigDecimal currentPrice) {
        this.currentPrice = currentPrice;
    }

    public long getMechantId() {
        return mechantId;
    }

    public void setMechantId(long mechantId) {
        this.mechantId = mechantId;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }

}
