package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

public class BasePrivilegeBean extends BaseBean {

    @ApiModelProperty("活动信息ID")
    private long id;

    @ApiModelProperty(value = "优惠活动标题", required = true)
    private String title;

    @ApiModelProperty(value = "活动抽奖策略(活动类型),支持：toponeStrategy(首名中奖)", required = true)
    private String strategy;

    @ApiModelProperty(value = "活动开启报名时间,默认当前时间")
    private Date startTime = new Date();

    @ApiModelProperty(value = "活动开奖时间（即结束时间）,到达开奖时间会自动根据抽奖策略进行奖品发放，默认一年后")
    private Date endTime = new Date(System.currentTimeMillis() + 31536000000l);

    @ApiModelProperty("活动显示的优先级，根据数字逆序排列。默认为0")
    private int order;

    @ApiModelProperty("活动开启抽奖的最少参与人数，与抽奖策略有关")
    private int lessParticipants;

    @ApiModelProperty("第一名必然中奖的策略下，最少需要达到的邀请人数要求")
    private int lessInviteNum;

    @ApiModelProperty("实际中奖人数（与抽奖策略有关）")
    private int actualNum;

    @ApiModelProperty(value = "奖品数量,必须大于0", required = true)
    private int prizeNum;

    @ApiModelProperty("活动当前状态,3-进行中,2-未开始,1-已结束,0-已取消。")
    private int status;

    @ApiModelProperty("活动是否上架，0：下架，1：上架")
    private int enable;

    @ApiModelProperty("商户ID")
    private long merchantId;

    @ApiModelProperty("商品ID")
    private long commodityId;

    @ApiModelProperty("是否全国投放，0：否，1：是")
    private int globalFlag;

    @ApiModelProperty("活动图片地址")
    private String imgUrl;

    @ApiModelProperty("缩略图地址")
    private String thumbnailUrl;

    @ApiModelProperty("分享背景图地址")
    private String shareBgUrl;

    @ApiModelProperty("活动详细内容（图文混排），HTML格式，对端内显示进行适配")
    private String content;

    @ApiModelProperty("活动引导语")
    private String guidance;

    @ApiModelProperty("活动的微信群二维码")
    private String barcode;

    @ApiModelProperty("带GIF图的活动的微信群二维码")
    private String barcodeGif;

    @ApiModelProperty("带二维码的活动海报图")
    private String codeUrl;

    @ApiModelProperty("活动折扣")
    private String discount;

    @ApiModelProperty("免费享商品标题")
    private String freeTitle;

    @ApiModelProperty("免费享条件")
    private String freeDetail;

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getCodeUrl() {
        return codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public String getGuidance() {
        return guidance;
    }

    public void setGuidance(String guidance) {
        this.guidance = guidance;
    }

    public String getBarcode() {
        return barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getBarcodeGif() {
        return barcodeGif;
    }

    public void setBarcodeGif(String barcodeGif) {
        this.barcodeGif = barcodeGif;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getShareBgUrl() {
        return shareBgUrl;
    }

    public void setShareBgUrl(String shareBgUrl) {
        this.shareBgUrl = shareBgUrl;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getEnable() {
        return enable;
    }

    public void setEnable(int enable) {
        this.enable = enable;
    }

    public int getGlobalFlag() {
        return globalFlag;
    }

    public void setGlobalFlag(int globalFlag) {
        this.globalFlag = globalFlag;
    }

    public int getActualNum() {
        return actualNum;
    }

    public void setActualNum(int actualNum) {
        this.actualNum = actualNum;
    }

    public long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(long merchantId) {
        this.merchantId = merchantId;
    }

    public long getCommodityId() {
        return commodityId;
    }

    public void setCommodityId(long commodityId) {
        this.commodityId = commodityId;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getLessParticipants() {
        return lessParticipants;
    }

    public void setLessParticipants(int lessParticipants) {
        this.lessParticipants = lessParticipants;
    }

    public int getLessInviteNum() {
        return lessInviteNum;
    }

    public void setLessInviteNum(int lessInviteNum) {
        this.lessInviteNum = lessInviteNum;
    }

    public int getPrizeNum() {
        return prizeNum;
    }

    public void setPrizeNum(int prizeNum) {
        this.prizeNum = prizeNum;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getFreeTitle() {
        return freeTitle;
    }

    public void setFreeTitle(String freeTitle) {
        this.freeTitle = freeTitle;
    }

    public String getFreeDetail() {
        return freeDetail;
    }

    public void setFreeDetail(String freeDetail) {
        this.freeDetail = freeDetail;
    }
}
