package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import springfox.documentation.annotations.ApiIgnore;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel(description = "帖子详情")
@Data
public class ForumPost {

    @ApiModelProperty("帖子id")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("作者头像")
    private String userImg;

    @ApiModelProperty("作者名称")
    private String userName;

    @ApiModelProperty("用户状态： 0-游客 1-可使用 2-未激活 3-虚拟 9-禁用")
    private Integer userState;

    @ApiModelProperty("马甲号用户信息，格式如：方仙女(女  单身，广德)")
    private String userInfo;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("发帖区域编码")
    private String areaCode;

    @ApiModelProperty("发帖区域")
    private String areaDetail;

    @ApiModelProperty("发帖地址")
    private String location;

    @ApiModelProperty("帖子文本")
    private String textField;

    @ApiModelProperty("帖子图片")
    private String imgList;

    @ApiModelProperty("帖子内容")
    private String content;

    @ApiModelProperty("是否精华帖：0否 1是")
    private Byte isBrilliant;

    @ApiModelProperty("是否推荐（是否优质头条）：0否 1是")
    private Byte isRecommend;

    @ApiModelProperty("是否红色章：0否 1是")
    private Byte isRed;

    @ApiModelProperty("是否奖励现金：0否 1是")
    private Byte isCash;

    @ApiModelProperty("是否本地爆料：0否 1是")
    private Byte isBroke;

    @ApiModelProperty("展示标签：1热 2爆")
    private Byte displayTag;

    @ApiModelProperty("帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)")
    private Byte status;

    @ApiModelProperty("定时发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date publishTime;

    @ApiModelProperty("展示时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date displayTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("版块id")
    private Long forumId;

    @ApiModelProperty("话题id列表")
    private List<Long> topicIdList;

    @ApiModelProperty("版块")
    private Forum forum;

    @ApiModelProperty("话题列表")
    private List<Topic> topicList;

    @ApiModelProperty(value = "阅读数")
    private Long clickCount;

    @ApiModelProperty(value = "创建人id，运营人员添加时才有值")
    private Long creator;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload;

    @ApiModelProperty("现金奖励金额")
    private BigDecimal cashReward;

    @ApiModelProperty("编辑寄语id")
    private Long editorMessageId;

    @ApiModelProperty("编辑寄语名称")
    private String editorMessageName;

    @ApiModelProperty(value = "编辑寄语",hidden = true)
    private String editorMessage;

    @ApiModelProperty("启用占位符")
    private Byte enablePlaceholder;

    @ApiModelProperty(value = "封面图片,如：" +
            "[\"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"," +
            " \"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"]")
    private String coverList;

    @ApiModelProperty(value = "视频图片,如：" +
            "[\"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"," +
            " \"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"]")
    private String videoPosterList;

    @ApiModelProperty("更新时间")
    private Date modifyTime;

    @ApiModelProperty("是否用户首次发帖")
    private Byte isFirstUserPost =0;

    @ApiModelProperty("帖子详情跳转地址")
    private String linkUrl;

    @ApiModelProperty("封面选择 0:只取图片 ,1:只取第一个视频 ,2:取内容详情的视频和图片 ")
    private Byte coverSelect;

    @ApiModelProperty("版块内容")
    private String forumContent;

    @ApiModelProperty("评论总数")
    private Integer commentCount;

    @ApiModelProperty("评论概览")
    private String  replyInfo;

    @ApiModelProperty("是否用户更新 0不是, 1用户更新")
    private Byte  isUserUpdate;

    @ApiModelProperty(value = "帖子使用的插件列表（JSON结构）",hidden = true)
    private String plugins;

    @ApiModelProperty("投票插件ID")
    private String votePluginId;

}
