package com.bxm.localnews.admin.vo;


import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@ApiModel(description = "新闻详情")
@Data
public class News extends BaseNews{

    @ApiModelProperty("地址详情")
    private String areaDetail;

    @ApiModelProperty("分类名称（一篇文章对应一个分类）")
    private String kindName;

    @ApiModelProperty("展示标签")
    private Integer showLevel;

    @ApiModelProperty("展示标签详情")
    private String showLevelDetail;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("新闻详情跳转地址")
    private String linkUrl;

    @ApiModelProperty("编辑寄语名称")
    private String editorMessageName;

    @ApiModelProperty("分享次数")
    private Long shares;

    @ApiModelProperty(value = "视频长度 单位秒",hidden = true)
    @JsonIgnore
    private Integer videoLen;

    @ApiModelProperty("视频地址")
    private String videoAddress;

    @ApiModelProperty("新闻视频封面信息")
    private String videoPosterList;


}