package com.bxm.localnews.admin.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(description = "新闻频道")
public class NewsKind {
    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("频道名称")
    private String name;

    @ApiModelProperty("排序号")
    private Integer sortNo;

    @ApiModelProperty("是否默认关注，0：否，1：是")
    private Byte defaultKind;

    @ApiModelProperty("是否固定顺序，0：否，1：是")
    private Byte fix;

    @ApiModelProperty("类型  1：新闻分类  2：视频分类")
    private Byte kindType;

    @ApiModelProperty("是否敏感内容（在提包时隐藏）:0不隐藏 1隐藏")
    private Byte sensitiveFlag;

    @ApiModelProperty("0:禁用，1：启用")
    private Byte status;
}
