package com.bxm.localnews.admin.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * a_virtual_user
 *
 * @author
 */
@Data
@ApiModel("马甲号实体信息")
public class VirtualUser implements Serializable {

    @ApiModelProperty("马甲号id（即用户id）")
    private Long id;

    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("头像")
    private String headImg;

    @ApiModelProperty(value = "累计现金收入（暂时没用）", hidden = true)
    private BigDecimal totalCash;

    @ApiModelProperty(value = "兑换商品（暂时没用）", hidden = true)
    private String exchangeCommodity;

    @ApiModelProperty("类型 1:评论马甲 2:发帖马甲 3:通用类")
    private Byte type;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    @ApiModelProperty(value = "修改时间", hidden = true)
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date modifyTime;

    @ApiModelProperty("性别 1：男 2：女")
    private Byte sex;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("生日")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date birthday;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("年龄段")
    private String ageGroup;

    @ApiModelProperty("婚育情况 0:保密 1:单身 2:恋爱中 3:已婚 4:离异")
    private Byte marry;

    @ApiModelProperty("房产情况 0:无房 1:租房 2:买房")
    private Byte house;

    @ApiModelProperty("工作情况 0:有工作 1:学生 2:全职妈妈 3:找工作 4:其他")
    private Byte work;

    @ApiModelProperty("兴趣爱好")
    private String hobby;

    @ApiModelProperty(value = "状态 默认为 3：正常", hidden = true)
    private Byte state = 3;

    public static VirtualUser buildVirtualUserQuery(Byte type, String nickname, String remark) {
        VirtualUser virtualUser = new VirtualUser();
        virtualUser.setType(type);
        virtualUser.setNickname(nickname);
        virtualUser.setRemark(remark);
        return virtualUser;
    }
}