package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * b_vote
 * @author liujia
 */
@ApiModel(description = "投票插件实体信息")
@Data
public class VoteBean implements Serializable {
    @ApiModelProperty("投票插件ID")
    private Long id;

    @ApiModelProperty("投票标题")
    private String title;

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("截止时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty("投票限制（策略），DAY:每日上限，MAX：总数上限")
    private String voteStrategy;

    @ApiModelProperty("票数上限")
    private Integer maxPoll;

    @ApiModelProperty(value = "RADIO：单选，CHECKBOX：多选")
    private String optionType;

    @ApiModelProperty(value = "更新时间",hidden = true)
    @JsonIgnore
    private Date modifyTime;

    @ApiModelProperty(value = "布局方案，TEXT：纯文本布局，IMG：图片布局",hidden = true)
    @JsonIgnore
    private String layoutType;

    @ApiModelProperty(value = "创建人(运营ID或用户ID)",hidden = true)
    @JsonIgnore
    private Long creator;

    @ApiModelProperty(value = "创建时间",hidden = true)
    @JsonIgnore
    private Date createTime;

    @ApiModelProperty(value = "是否删除",hidden = true)
    @JsonIgnore
    private Byte deleteFlag;

    @ApiModelProperty(value = "删除时间",hidden = true)
    @JsonIgnore
    private Date deleteTime;

    @ApiModelProperty(value = "删除人ID",hidden = true)
    @JsonIgnore
    private Long deleteUserId;

    @ApiModelProperty(value = "投票选项")
    private List<VoteOptionsBean> options;

    private static final long serialVersionUID = 1L;
}