package com.bxm.localnews.admin.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * b_vote_options
 * @author liujia
 */
@Data
@ApiModel(description = "投票选项实体")
public class VoteOptionsBean implements Serializable {
    @ApiModelProperty("选项ID")
    private Long id;

    @ApiModelProperty("投票插件ID")
    private Long voteId;

    @ApiModelProperty("选项文案")
    private String text;

    @ApiModelProperty("选项图片路径")
    private String imgUrl;

    @ApiModelProperty(value = "选项顺序,根据提交顺序固定",hidden = true)
    @JsonIgnore
    private Integer order;

    @ApiModelProperty(value = "是否删除",hidden = true)
    @JsonIgnore
    private Byte deleteFlag;

    @ApiModelProperty(value = "删除时间",hidden = true)
    @JsonIgnore
    private Date deleteTime;

    @ApiModelProperty(value = "删除人ID",hidden = true)
    @JsonIgnore
    private Long deleteUserId;

    private static final long serialVersionUID = 1L;
}