package com.bxm.localnews.admin.constant;

import com.bxm.localnews.admin.dto.AdvertTypeDTO;

import java.util.ArrayList;
import java.util.List;

/**
 * 广告类型枚举
 * --小程序广告位以MINI_PROGRAM_开头
 * @author donghy
 */
public enum AdvertTypeEnum {
    INDEX_POP_WINDOW(1,"首页弹窗广告"),
    DAILY_TASK(2, "日常任务广告"),
    TURN_AROUND_ADVERT(3,"轮播广告"),
    TURN_AROUND_PERSONAL_CENTER(4,"个人中心轮播广告"),
    START_SCREEN(7,"开屏广告"),
    INDEX_CONFIG(8,"首页配置广告"),
    TURN_AROUND_SIGN_IN(9,"签到中心轮播广告"),
    TURN_AROUND_MESSAGE_CENTER(10,"消息中心轮播广告"),
    COMMUNITY_INDEX_CONTENT(11,"社区首页广告"),
    IOS_RED_PACKET(12, "IOS红包墙广告位"),
    MINI_PROGRAM_INDEX_BANNER(13, "小程序首页banner"),
    MINI_PROGRAM_SUSPEND(14,"小程序悬浮广告"),
    MINI_PROGRAM_POP_WINDOW(15,"小程序首页弹窗广告"),
    PUBLISH_SUC_BOTTOM(16,"发布成功底部广告位"),
    CONVENIENCE_CENTER(17,"便民中心广告位"),
    POST_SHARE_SUSPEND(18,"帖子分享页悬浮广告"),
    NEWS_SHARE_SUSPEND(19,"新闻分享页悬浮广告"),
    POST_SHARE_BANNER(20,"帖子分享页banner广告"),
    NEWS_SHARE_BANNER(21,"新闻分享页banner广告"),
    PUBLISH_SUSPEND(22,"发布成功悬浮广告"),
    NEWS_DETAIL_BANNER(23,"新闻内容详情广告位"),
    POST_DETAIL_BANNER(24,"帖子内容详情广告位"),

    ;


    AdvertTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    /**
     * 广告类型数字编码
     */
    private int code;

    /**
     * 广告类型名称
     */
    private String name;

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取广告类型中所有枚举类型
     * @return 广告类型所有枚举类型
     */
    public static List<AdvertTypeDTO> getAllType() {
        List<AdvertTypeDTO> advertTypeDTOList = new ArrayList<>(AdvertTypeEnum.values().length);
        for (AdvertTypeEnum result : AdvertTypeEnum.values()) {
            AdvertTypeDTO advertTypeDTO = new AdvertTypeDTO();
            advertTypeDTO.setAdvertTypeCode(result.getCode());
            advertTypeDTO.setAdvertTypeName(result.getName());

            advertTypeDTOList.add(advertTypeDTO);

        }
        return advertTypeDTOList;
    }

    /**
     * 根据code获取name
     * @param code 广告类型code
     * @return 广告的名称
     */
    public static String getNameByCode(int code) {
        for (AdvertTypeEnum advertTypeEnum : AdvertTypeEnum.values()) {
            if (code == advertTypeEnum.getCode()) {
                return advertTypeEnum.getName();
            }
        }

        return null;
    }




}
