package com.bxm.localnews.admin.constant;

/**
 * 帖子状态枚举类
 * @author shentao
 */
public enum PostStatusEnum {

    ENABLE((byte)1,"正常显示"),
    UN_REVIEWED((byte)2,"审核中"),
    REJECTED((byte)3,"已拒绝"),
    USER_DELETE((byte)4,"未审核"),
    LANDLORD((byte)5,"已拒绝"),
    LOCAL_SHIELD((byte)6,"已审核"),
    ADMIN_DELETE((byte)7,"已审核")

    ;


    PostStatusEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }


    private int code;

    private String name;

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
