package com.bxm.localnews.admin.constant;

/**
 * @author zhaoyadong 2019/1/17 10:13
 * @desc
 */
public enum PushMessageStatusEnum {

    STAY_CONFIRM((byte) 0, "待确认"), STAY_SEND((byte) 1, "待发送"),
    HAS_BEEN_SEND((byte) 2, "已发送"), BEING_SEND((byte) 3, "推送中");

    private Byte type;

    private String desc;

    PushMessageStatusEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getPushMessageStatusEnumByType(Byte type) {
        for (PushMessageStatusEnum pushMessageStatusEnum : PushMessageStatusEnum.values()) {
            if (pushMessageStatusEnum.getType().equals(type)) {
                return pushMessageStatusEnum.getDesc();
            }
        }
        return null;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
