package com.bxm.localnews.admin.constant;

import com.bxm.localnews.admin.vo.AdminPushMessage;
import com.bxm.localnews.mq.common.constant.ActionTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;

/**
 * @author zhaoyadong 2019/2/21 18:29
 * @desc
 */
public enum PushPayloadInfoEnum {

    OPEN_NEWS(ActionTypeEnum.OPEN_NEWS.getType()) {
        @Override
        public PushPayloadInfo excute(PushPayloadInfo payloadInfo, AdminPushMessage adminPushMessage) {
            payloadInfo.setType(PushMessageEnum.NEWS.getType());
            payloadInfo.addExtend("newsId", adminPushMessage.getActionParams());
            payloadInfo.addExtend("type", 1);
            return payloadInfo;
        }
    },

    OPEN_URL(ActionTypeEnum.OPEN_URL.getType()) {
        @Override
        public PushPayloadInfo excute(PushPayloadInfo payloadInfo, AdminPushMessage adminPushMessage) {
            payloadInfo.setType(PushMessageEnum.OPEN_URL.getType());
            payloadInfo.addExtend("url", adminPushMessage.getActionParams());
            return payloadInfo;
        }
    },

    VIP_NOT_ACTIVATION(ActionTypeEnum.VIP_NOT_ACTIVATION.getType()) {
        @Override
        public PushPayloadInfo excute(PushPayloadInfo payloadInfo, AdminPushMessage adminPushMessage) {
            payloadInfo.setType(PushMessageEnum.VIP_NOT_ACTIVATION.getType());
            payloadInfo.addExtend("url", adminPushMessage.getActionParams());
            return payloadInfo;
        }
    },

    VIP_CONTINUE_ACTIVATION(ActionTypeEnum.VIP_CONTINUE_ACTIVATION.getType()) {
        @Override
        public PushPayloadInfo excute(PushPayloadInfo payloadInfo, AdminPushMessage adminPushMessage) {
            payloadInfo.setType(PushMessageEnum.VIP_CONTINUE_ACTIVATION.getType());
            payloadInfo.addExtend("url", adminPushMessage.getActionParams());
            return payloadInfo;
        }
    },

    VIP_ACTIVATION(ActionTypeEnum.VIP_ACTIVATION.getType()) {
        @Override
        public PushPayloadInfo excute(PushPayloadInfo payloadInfo, AdminPushMessage adminPushMessage) {
            payloadInfo.setType(PushMessageEnum.VIP_ACTIVATION.getType());
            payloadInfo.addExtend("url", adminPushMessage.getActionParams());
            return payloadInfo;
        }
    };

    private Byte actionType;

    PushPayloadInfoEnum(Byte actionType) {
        this.actionType = actionType;
    }

    public abstract PushPayloadInfo excute(PushPayloadInfo pushPayloadInfo, AdminPushMessage adminPushMessage);
}
