package com.bxm.localnews.admin.convert.impl;

import com.bxm.localnews.admin.convert.Converter;
import com.bxm.localnews.admin.vo.NewsKind;
import com.bxm.localnews.news.domain.NewsKindMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Optional;

abstract class AbstractConverter<T, K> implements Converter<T, K> {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    private List<NewsKind> kinds;

    private long lastSyncTime;

    private long expireTime = 300000L;

    @Autowired
    private NewsKindMapper newsKindMapper;

    public Long getKindId(String kindName) {
        Optional<NewsKind> kind = this.getKinds().stream().filter(newsKind -> newsKind.getName().equals(kindName.trim())).findFirst();
        return kind.isPresent() ? kind.get().getId() : 0;
    }

    public String getKindName(Long kindId) {
        Optional<NewsKind> kind = this.getKinds().stream().filter(newsKind -> newsKind.getId().equals(kindId)).findFirst();
        return kind.map(NewsKind::getName).orElse(null);
    }

    boolean hasKindId(int kindId) {
        return this.getKinds().stream().anyMatch(kind -> kind.getId() == kindId);
    }

    public NewsKind getKind(int kindId) {
        return this.getKinds().stream().filter(kind -> kindId == kind.getId()).findFirst().orElse(new NewsKind());
    }

    private List<NewsKind> getKinds() {
        if (null == this.kinds || System.currentTimeMillis() - this.lastSyncTime > this.expireTime) {
            this.kinds = this.newsKindMapper.selectAllKinds();
            this.lastSyncTime = System.currentTimeMillis();
        }
        return this.kinds;
    }
}
