package com.bxm.localnews.admin.convert.impl;

import com.bxm.localnews.admin.param.AdminNewsPageParam;
import com.bxm.localnews.admin.param.NewsParam;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class AdminNewsPageConverter extends AbstractConverter<NewsParam, AdminNewsPageParam> {

    @Override
    public AdminNewsPageParam convert(NewsParam data) {
        AdminNewsPageParam adminNewsPageParam = new AdminNewsPageParam();
        BeanUtils.copyProperties(data, adminNewsPageParam);
        adminNewsPageParam.setKeyword(data.getTitle());
        adminNewsPageParam.setAreaCode(data.getAreaName());
        return adminNewsPageParam;
    }
}
