package com.bxm.localnews.admin.convert.impl;

import com.bxm.localnews.admin.convert.Converter;
import com.bxm.localnews.admin.param.CommentReplyParam;
import com.bxm.localnews.admin.vo.NewsReply;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component
public class CommentReplyConverter extends BaseService implements Converter<CommentReplyParam, NewsReply> {
	private final NewsReplyMapper newsReplyMapper;
	private final UserReplyMapper userReplyMapper;

	@Autowired
	public CommentReplyConverter(NewsReplyMapper newsReplyMapper,
								 UserReplyMapper userReplyMapper){
		this.newsReplyMapper = newsReplyMapper;
		this.userReplyMapper = userReplyMapper;

	}

	@Override
	public NewsReply convert(CommentReplyParam param) {
		NewsReply parentReply = newsReplyMapper.selectByPrimaryKey(param.getParentReplyId(), param.getNewsId());
		NewsReply newsReply = new NewsReply();
		//评论设置为不展示
		newsReply.setId(nextId());
		newsReply.setStatus((byte) 0);
		newsReply.setDeleteFlag((byte) 0);
		newsReply.setInteractiveCount(0);
		newsReply.setLikeCount(0);
		newsReply.setParentId(parentReply.getId());
		newsReply.setType(parentReply.getType());
		newsReply.setParentUserId(parentReply.getUserId());
		newsReply.setParentHeadImg(parentReply.getHeadImg());
		newsReply.setParentUserNickname(parentReply.getUserNickname());
		newsReply.setNewsId(param.getNewsId());
		newsReply.setHeadImg(param.getVirtualHeadImg());
		newsReply.setUserId(param.getVirtualUserId());
		newsReply.setAddTime(param.getReplyTime());
		newsReply.setUserNickname(param.getVirtualNickName());
		newsReply.setReplyContent(param.getReplyContent());
		//根据上级评论id判断newsreply的level,rootId,
		if (parentReply.getLevel() == 0){
			newsReply.setLevel((byte) 1);
			newsReply.setRootId(parentReply.getId());
		}else if (parentReply.getLevel() == 1){
			newsReply.setLevel((byte) 2);
			newsReply.setRootId(parentReply.getRootId());
		}else if (parentReply.getLevel() == 2){
			newsReply.setLevel((byte) 2);
			newsReply.setRootId(parentReply.getRootId());
		}
		//更新上级评论的马甲号互动
		if (Objects.nonNull(parentReply.getVestInteract()) && parentReply.getVestInteract() == 0 ){
			newsReplyMapper.updateVestInteractById(parentReply.getId(),parentReply.getNewsId());
			userReplyMapper.updateVestInteractById(parentReply.getId(),parentReply.getUserId());
		}

		return newsReply;
	}
}
