package com.bxm.localnews.admin.convert.impl;

import com.bxm.localnews.admin.convert.Converter;
import com.bxm.localnews.admin.param.EditorMessageParam;
import com.bxm.localnews.admin.vo.EditorMessage;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import java.util.Date;

@Component
public class EditorMessageConverter implements Converter<EditorMessageParam, EditorMessage> {

	@Override
	public EditorMessage convert(EditorMessageParam param) {
		EditorMessage editorMessage = new EditorMessage();
		BeanUtils.copyProperties(param,editorMessage);
		Date current = new Date();
		editorMessage.setCreateTime(current);
		editorMessage.setModifyTime(current);
		editorMessage.setCreateId(param.getUserId());
		return editorMessage;
	}
}
