package com.bxm.localnews.admin.convert.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.convert.Converter;
import com.bxm.localnews.admin.param.BaseFlowerParam;
import com.bxm.localnews.admin.param.FlowerParam;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Component;

import java.util.List;
@Component
public class SendFlowConvert implements Converter<FlowerParam,List<BaseFlowerParam.UserFlower>> {


	@Override
	public List<BaseFlowerParam.UserFlower> convert(FlowerParam data) {
		String template = data.getTemplate();
		List<String> templates = JSONObject.parseArray(template, String.class);
		List<BaseFlowerParam.UserFlower> result = Lists.newArrayList();
		templates.stream().forEach(e->{
			BaseFlowerParam.UserFlower flower = new BaseFlowerParam.UserFlower();
			if (StringUtils.isNotBlank(e)){
				String[] info = e.split(",");
				flower.setUserId(NumberUtils.toLong(info[0]));
				flower.setFlowerNum(NumberUtils.toInt(info[1]));
				result.add(flower);
			}

		});

		return result;
	}
}
