package com.bxm.localnews.admin.convert.impl;

import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.VirtualUser;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class VirtualUserInfoConverter extends AbstractConverter<VirtualUserInfoParam, VirtualUser> {

    @Override
    public VirtualUser convert(VirtualUserInfoParam data) {
        VirtualUser user = new VirtualUser();
        user.setId(data.getId());
        user.setNickname(data.getNickname());
        user.setHeadImg(data.getHeadImg());
        user.setSex(data.getSex());
        user.setCreateTime(new Date());
        user.setModifyTime(new Date());
        user.setBirthday(data.getBirthday());
        user.setAddress(data.getAddress());
        user.setRemark(data.getRemark());
        user.setType(data.getType());
        user.setState(data.getState());
        user.setAgeGroup(data.getAgeGroup());
        user.setMarry(data.getMarry());
        user.setHouse(data.getHouse());
        user.setWork(data.getWork());
        user.setHobby(data.getHobby());
        return user;
    }

}
