package com.bxm.localnews.admin.service.activity;

import com.bxm.localnews.admin.param.MerchantParam;
import com.bxm.localnews.admin.param.MerchantQueryParam;
import com.bxm.localnews.admin.vo.MerchantBean;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 商户信息相关业务接口
 */
public interface MerchantService {

    /**
     * 分页获取商户信息
     * @param param 商户信息查询参数
     * @return 分页结果
     */
    PageWarper<MerchantBean> getMerchants(MerchantQueryParam param);

    /**
     * 根据商户ID获取商户详情
     * @param id 商户ID
     * @return 商户信息
     */
    MerchantBean getMerchant(long id);

    /**
     * 新增商户信息
     * @param param 商户信息参数
     * @return 保存结果
     */
    Message save(MerchantParam param);

    /**
     * 变更商户信息
     * @param param 商户变更参数
     * @return 变更结果
     */
    Message modify(MerchantParam param);

    /**
     * 根据商户名获取前10匹配的商户信息
     * @param merchantName 商户名称或编码
     * @return 商户信息列表
     */
    List<MerchantBean> getTopMatch(String merchantName);

    /**
     * 变更商户审核状态
     * @param id           商户ID
     * @param status       审核结果
     * @param rejectReason 审核结果
     * @return 变更结果
     */
    Message changeStatus(long id, int status, String rejectReason);

    /**
     * 删除商户信息
     * @param id 商户ID
     * @return 删除结果
     */
    Message remove(long id);

}
