package com.bxm.localnews.admin.service.activity;

import com.bxm.localnews.admin.param.VoteQueryParam;
import com.bxm.localnews.admin.vo.VoteBean;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 投票插件相关服务接口
 * @author liujia
 */
public interface VoteService {
    /**
     * 获取投票详情，包括选项
     * @param voteId 投票插件ID
     * @return 投票详情
     */
    VoteBean get(Long voteId);

    /**
     * 分页查询投票查询信息
     * @param param 分页查询参数
     * @return 分页结果
     */
    PageWarper<VoteBean> getVoteByPage(VoteQueryParam param);

    /**
     * 获取可用状态的投票插件列表
     * @return 投票插件列表
     */
    List<VoteBean> getEnableVotes();

    /**
     * 移除分页插件信息
     * @param voteId 分页插件ID
     * @return 移除结果
     */
    Message remove(Long voteId);

    /**
     * 新增或更新投票插件信息
     * @param entity 投票插件信息
     * @return 保存结果
     */
    Message save(VoteBean entity);
}
