package com.bxm.localnews.admin.service.activity.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.admin.config.DingtalkProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.convert.impl.SendFlowConvert;
import com.bxm.localnews.admin.domain.GoldFlowMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.FolwerDTO;
import com.bxm.localnews.admin.integration.UserAccountIntegrationService;
import com.bxm.localnews.admin.param.AccountGoldParam;
import com.bxm.localnews.admin.param.BaseFlowerParam;
import com.bxm.localnews.admin.param.FlowerParam;
import com.bxm.localnews.admin.service.PushMsgIntegService;
import com.bxm.localnews.admin.service.activity.GiveOutFlowerService;
import com.bxm.localnews.admin.vo.GoldFlow;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service
public class GiveOutFlowerServiceImpl extends BaseService implements GiveOutFlowerService {

    private final SendFlowConvert sendFlowConvert;

    private final UserAccountIntegrationService userAccountIntegrationService;

    private final UserMapper userMapper;

    private final RedisStringAdapter redisStringAdapter;

    private final HttpClientService httpClientService;

    private final DingtalkProperties dingtalkProperties;

    private final PushMsgIntegService pushMsgIntegService;

    private final GoldFlowMapper goldFlowMapper;

    @Autowired
    public GiveOutFlowerServiceImpl(SendFlowConvert sendFlowConvert,
                                    UserAccountIntegrationService userAccountIntegrationService,
                                    UserMapper userMapper,
                                    RedisStringAdapter redisStringAdapter,
                                    HttpClientService httpClientService,
                                    DingtalkProperties dingtalkProperties,
                                    PushMsgIntegService pushMsgIntegService,
                                    GoldFlowMapper goldFlowMapper) {
        this.sendFlowConvert = sendFlowConvert;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.userMapper = userMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.httpClientService = httpClientService;
        this.dingtalkProperties = dingtalkProperties;
        this.pushMsgIntegService = pushMsgIntegService;
        this.goldFlowMapper = goldFlowMapper;
    }


    @Override
    public Long getUniquelyId() {
        return this.nextId();
    }

    @Override
    public FolwerDTO doSendFolwer(FlowerParam flowerParam, AdminUser adminUser) {
        FolwerDTO result = new FolwerDTO();
        //转化参数
        List<BaseFlowerParam.UserFlower> userFlowers = sendFlowConvert.convert(flowerParam);
        //校验用户是否存在,用户有不存在信息,直接返回
        List<Long> notExitIds = checkUserExits(userFlowers);
        if (CollectionUtils.isNotEmpty(notExitIds)) {
            result.setSuccessCode(1);
            result.setNotExitIds(notExitIds);
        } else {
            result = caculateFlower(userFlowers, flowerParam, result, adminUser);
        }
        return result;
    }


    /**
     * 发放红花业务逻辑
     * @param userFlowers
     * @param flowerParam
     * @param result
     * @return
     */
    private FolwerDTO caculateFlower(List<BaseFlowerParam.UserFlower> userFlowers,
                                     FlowerParam flowerParam, FolwerDTO result, AdminUser adminUser) {
        //判断红花数量是否小于1000
        int folwerNum = userFlowers.stream().mapToInt(BaseFlowerParam.UserFlower::getFlowerNum).sum();
        if (folwerNum < 1000) {
            //发放红花
            sendflower(userFlowers, flowerParam, result, adminUser);
        } else {
            //获得验证码
            String verifyCode = redisStringAdapter.getString(getVerifyCodeKey(flowerParam));
            if (StringUtils.isNotBlank(verifyCode)) {
                //前端验证码不为空时校验
                if (StringUtils.isNotBlank(flowerParam.getVerifyCode())) {
                    if (verifyCode.equalsIgnoreCase(flowerParam.getVerifyCode())) {
                        //发放红花
                        sendflower(userFlowers, flowerParam, result, adminUser);
                        //清除验证码
                        redisStringAdapter.remove(getVerifyCodeKey(flowerParam));
                    } else {
                        //验证码错误
                        result.setSuccessCode(3);
                    }
                } else {
                    result.setSuccessCode(2);
                }

            } else {
                //发送验证码
                sendVerifyCode(flowerParam, folwerNum, userFlowers.size());
                result.setSuccessCode(2);
            }

        }
        return result;

    }


    private void sendVerifyCode(FlowerParam flowerParam, int folwerNum, int peopleNum) {
        String verifyCode = RandomStringUtils.random(4, false, true);
        StringBuilder content = new StringBuilder();
        content.append("【红花发放验证码:")
                .append(verifyCode).append(",总计").append(folwerNum)
                .append("红花, 共").append(peopleNum).append("人 ")
                .append("，备注：").append(flowerParam.getReason()).append("】");
        JSONObject text = new JSONObject();
        text.put("content", content);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);
        String response = httpClientService.doPostJson(dingtalkProperties.getVerifyCodeWebhook(), msg.toJSONString());
        logger.debug("dingding response:{}", response);
        redisStringAdapter.set(getVerifyCodeKey(flowerParam), verifyCode, 900);
    }

    /**
     * 获得验证码key
     * @param flowerParam
     * @return
     */
    private KeyGenerator getVerifyCodeKey(FlowerParam flowerParam) {
        KeyGenerator flowerKey = RedisConfig.CACULATE_FLOWER.copy();
        BaseFlowerParam param = new BaseFlowerParam();
        BeanUtils.copyProperties(flowerParam, param);
        int code = param.hashCode();
        KeyGenerator keyGenerator = flowerKey.appendKey(code);
        return keyGenerator;
    }

    /**
     * 判断用户是否存在
     * @param userFlowers
     * @return
     */
    private List<Long> checkUserExits(List<BaseFlowerParam.UserFlower> userFlowers) {
        List<Long> result = Lists.newArrayList();
        userFlowers.forEach(e -> {
            User user = userMapper.selectByUserId(e.getUserId());
            if (Objects.isNull(user) || user.getState() != 1) {
                result.add(e.getUserId());
            }
        });
        return result;
    }

    /**
     * 发放红花
     * @param userFlowers
     * @param flowerParam
     */
    private void sendflower(List<BaseFlowerParam.UserFlower> userFlowers, FlowerParam flowerParam, FolwerDTO result, AdminUser adminUser) {
        final String reason;
        if (StringUtils.isNotBlank(flowerParam.getReason())) {
            reason = flowerParam.getReason() + "," + adminUser.getName();
        } else {
            reason = adminUser.getName();
        }
        String url = "wst://mine/flowerRecord?index=0";
        userFlowers.stream().forEach(e -> {
            //给用户添加金币
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(e.getUserId());
            param.setGold(e.getFlowerNum());
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("ACTIVITY_GIVEOUT");
            param.setAddTotal(true);
            param.setRelationId(flowerParam.getId());
            param.setReason(reason);
            userAccountIntegrationService.addGold(param);
            PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
            info.addExtend("msgId", nextId());
            info.addExtend("url", url);
            PushMessage message = PushMessage.build();
            message.setTitle("");
            message.setContent(flowerParam.getCopyWrite());
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle(e.getUserId()));
            message.setPayloadInfo(info);
            this.pushMsgIntegService.pushMsg(message);
        });
        result.setSuccessCode(0);
    }

    @Override
    public PageWarper<GoldFlow> listFlower(PageParam pageParam) {
        return new PageWarper<GoldFlow>(goldFlowMapper.giveOutFlowerList(pageParam));
    }

}
