package com.bxm.localnews.admin.service.activity.impl;


import com.bxm.localnews.admin.config.HelpInfoProperties;
import com.bxm.localnews.admin.domain.HelpInfoMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.param.HelpInfoQueryParam;
import com.bxm.localnews.admin.service.activity.HelpInfoService;
import com.bxm.localnews.admin.vo.HelpInfo;
import com.bxm.localnews.admin.vo.User;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;

@Service
public class HelpInfoServiceImpl implements HelpInfoService {

    @Resource
    private HelpInfoMapper helpInfoMapper;

    @Resource
    private UserMapper userMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private HelpInfoProperties helpInfoProperties;

    @Override
    public PageWarper<HelpInfo> getList(HelpInfoQueryParam param) {
        PageWarper<HelpInfo> result = new PageWarper<>(helpInfoMapper.getList(param));

        if (CollectionUtils.isNotEmpty(result.getList())) {
            for (HelpInfo helpInfo : result.getList()) {
                completeInfo(helpInfo);
            }
        }

        return result;
    }

    @Override
    public HelpInfo getDetailById(Long id) {
        HelpInfo helpInfo = helpInfoMapper.selectByPrimaryKey(id);
        completeInfo(helpInfo);

        return helpInfo;
    }

    @Override
    public Message saveOrUpdate(HelpInfo helpInfo) {
        if (null == helpInfo.getType() || ((byte) 1 != helpInfo.getType() && (byte) 2 != helpInfo.getType())) {
            return Message.build(false).setMessage("参数有误");
        }
        if ((byte) 2 == helpInfo.getType() && (null == helpInfo.getHelperName() || null == helpInfo.getCreator())) {
            return Message.build(false).setMessage("参数有误");
        }

        int update;
        Long id = helpInfo.getId();

        if (null == id) {
            if ((byte) 1 == helpInfo.getType()) {
                //判断用户是否已经助力过
                if (helpInfoMapper.countUserHelpInfo(helpInfo.getHelperId()) > 0) {
                    return Message.build(false).setMessage("该用户已经助力过活动");
                }
                //个人助力
                User user = userMapper.selectByUserId(helpInfo.getHelperId());
                if (null == user) {
                    return Message.build(false).setMessage("查不到对应用户");
                }
                helpInfo.setHelperName(user.getNickname());
                helpInfo.setHelperImg(user.getHeadImg());
            } else if ((byte) 2 == helpInfo.getType()) {
                //判断用户是否已经助力过
                if (helpInfoMapper.countUserHelpInfo(helpInfo.getCreator()) > 0) {
                    return Message.build(false).setMessage("该用户已经助力过活动");
                }
                //重名校验
                if (helpInfoMapper.countHelpTeamByName(helpInfo.getHelperName()) > 0) {
                    return Message.build(false).setMessage("已存在该团队名");
                }

                //团队助力
                User creator = userMapper.selectByUserId(helpInfo.getCreator());
                if (null == creator) {
                    return Message.build(false).setMessage("查不到对应发起人");
                }
                helpInfo.setCreatorName(creator.getNickname());
                helpInfo.setCreatorImg(creator.getHeadImg());

                //创建团队信息
                helpInfo.setHelperId(sequenceCreater.nextLongId());
                if (StringUtils.isBlank(helpInfo.getHelperImg())) {
                    helpInfo.setHelperImg(helpInfoProperties.getDefaultTeamImg());
                }
                helpInfoMapper.insertTeamInfo(helpInfo);
                //创建用户团队关联关系
                helpInfoMapper.insertTeamUserRelation(helpInfo.getHelperId(), helpInfo.getCreator());
            }

            helpInfo.setId(sequenceCreater.nextLongId());
            update = helpInfoMapper.insertSelective(helpInfo);
        } else {
            update = helpInfoMapper.updateByPrimaryKeySelective(helpInfo);

            if ((byte) 2 == helpInfo.getType()) {
                //修改团队信息
                helpInfoMapper.updateTeamInfo(helpInfo);
            }
        }

        if (update > 0) {
            return Message.build(true);
        } else {
            return Message.build(false).setMessage("数据库操作失败");
        }
    }

    private void completeInfo(HelpInfo helpInfo) {
        if (null == helpInfo) {
            return;
        }

        //补充团队信息
        if ((byte) 2 == helpInfo.getType()) {
            HelpInfo teamInfo = helpInfoMapper.selectTeamInfoById(helpInfo.getHelperId());
            helpInfo.setCreator(teamInfo.getCreator());
            helpInfo.setCreatorName(teamInfo.getCreatorName());
            helpInfo.setCreatorImg(teamInfo.getCreatorImg());
        }

    }

}
