package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.service.base.ShortLinkService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.bxm.localnews.admin.constant.RedisConfig.SHORT_URL;

@Service
public class ShortLinkServiceImpl implements ShortLinkService {

    private BizConfigProperties bizConfigProperties;

    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public ShortLinkServiceImpl(BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter) {
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public String getShortUrl(String url, boolean expired) {
        //短连接地址
        StringBuilder sortUrl = new StringBuilder();
        String host = bizConfigProperties.getServerHost();
        sortUrl.append(host).append("/").append("t").append("/");
        String key = ShortUrlGenerator.getShortUrl(url)[0];
        sortUrl.append(key);
        //缓存180天，超时，则跳转到注册界面
        if (expired) {
            this.redisStringAdapter.set(SHORT_URL.copy().appendKey(key), url, 3600 * 24 * 90);
        } else {
            this.redisStringAdapter.set(SHORT_URL.copy().appendKey(key), url);
        }
        return sortUrl.toString();
    }

    @Override
    public String getPrivilegeShareShortLink(String param) {
        String url = null;
        url = bizConfigProperties.getPrivilegeShareUrl() + "?" + param;
        return getShortUrl(url, true);
    }

}
