package com.bxm.localnews.admin.service.forum;

import com.bxm.localnews.admin.param.ForumPostParam;
import com.bxm.localnews.admin.vo.ForumPost;
import com.bxm.localnews.admin.vo.ForumPostApproveHistory;
import com.bxm.localnews.admin.vo.PostImg;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import java.util.List;

/**
 * 帖子管理服务
 */
public interface ForumPostService {

    /**
     * 查询帖子审核列表
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<ForumPost> getApproveList(ForumPostParam param);

    /**
     * 获取帖子详情
     * @param id
     * @return
     */
    ForumPost selectByPrimaryKey(Long id);

    /**
     * 批量审核
     * @param ids
     * @param status
     * @param comment
     * @param userId
     * @return 更新信息
     */
    int approve(String ids, Byte status, String comment, Long userId);

    /**
     * 新增或编辑帖子
     * @param forumPost
     * @return
     */
    Message saveOrUpdate(ForumPost forumPost,Long userId);

    /**
     * 批量删除或恢复帖子
     * @param ids
     * @param status
     * @param deductGold
     * @return
     */
    int deleteOrRecover(String ids, Byte status, Byte deductGold);

    /**
     * 获取新增帖子id
     * @return
     */
    Long getCreateId();

    /**
     * 获取帖子审核历史列表
     * @param id
     * @param action
     * @return
     */
    List<ForumPostApproveHistory> getApproveHistoryList(Long id, Integer action);

    /**
     * 分析文章内容填补video标签中的封面
     * @param content
     * @param postImgList
     * @return
     */
    String extractVideoAndImgFromContent(String content,String videoPosterList, List<PostImg> postImgList, List<String> imgList);

    /**
     * 将帖子转换为新闻
     * @param id
     * @return
     */
    Json transformPost2News(Long id);

    /**
     * 帖子添加马甲号点赞
     * @param postId
     * @param startTime
     * @param endTime
     * @param num
     * @return
     */
	Message doAddPostLike(Long postId, Date startTime, Date endTime, Integer num);

    String getForumPostTitle(String title, String textField);

    String getForumPostTitleTotally(String title, String textField);
}
