package com.bxm.localnews.admin.service.forum;

import com.bxm.localnews.admin.param.ReplyLibraryCategoryParam;
import com.bxm.localnews.admin.vo.ReplyLibraryCategory;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 评论库类别管理服务
 */
public interface ReplyLibraryCategoryService {

    /**
     * 分页查询评论类别
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<ReplyLibraryCategory> getList(ReplyLibraryCategoryParam param);

    /**
     * 获取评论类别详情
     *
     * @param id
     * @return
     */
    ReplyLibraryCategory selectByPrimaryKey(Long id);

    /**
     * 新增评论类别
     *
     * @param replyLibraryCategory
     * @return
     */
    int insert(ReplyLibraryCategory replyLibraryCategory);

    /**
     * 编辑评论类别
     *
     * @param replyLibraryCategory
     * @return
     */
    int updateByPrimaryKey(ReplyLibraryCategory replyLibraryCategory);

    /**
     * 删除评论类别
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

}
