package com.bxm.localnews.admin.service.forum;

import com.bxm.localnews.admin.param.TopicParam;
import com.bxm.localnews.admin.vo.Topic;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 话题管理服务
 */
public interface TopicService {

    /**
     * 查询话题
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<Topic> getList(TopicParam param);

    /**
     * 获取话题详情
     *
     * @param id
     * @return
     */
    Topic selectByPrimaryKey(Long id);

    /**
     * 话题上下架删除
     *
     * @param id
     * @param status
     * @return 更新信息
     */
    int updateStatus(Long id, Byte status);

    /**
     * 新增或编辑话题
     *
     * @param topic
     * @return
     */
    int saveOrUpdate(Topic topic);

    /**
     * 修改话题权重
     *
     * @param id
     * @param order
     * @return
     */
    int updateOrder(Long id, Integer order);

    /**
     * 获取简单话题列表
     *
     * @param key 关键字
     * @return
     */
    List<Topic> getSimpleList(String key);

    /**
     * 获取话题下的帖子数
     *
     * @param id
     * @return
     */
    Integer getPostNumByTopicId(Long id);

    /**
     * 充值帖子的话题列表
     * @param id
     * @param topicList
     */
    void resetForumPostTopic(Long id,List<Long> topicList);
}
