package com.bxm.localnews.admin.service.forum.impl;

import java.net.URLDecoder;
import java.util.*;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.MixRecommendTypeEnum;
import com.bxm.localnews.admin.constant.NewsStatusEnum;
import com.bxm.localnews.admin.constant.PostStatusEnum;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.integration.NewsIntegrationService;
import com.bxm.localnews.admin.integration.UserAccountIntegrationService;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.seq.NewsSeqComponent;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.service.PushMsgIntegService;
import com.bxm.localnews.admin.service.QuartzIntegrationService;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.service.forum.ForumPostService;
import com.bxm.localnews.admin.service.forum.TopicService;
import com.bxm.localnews.admin.service.news.AdminNewsService;
import com.bxm.localnews.admin.service.news.CommonTagService;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.admin.service.security.BaseAdminService;
import com.bxm.localnews.admin.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.admin.vo.*;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.domain.*;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.HtmlContentUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ForumPostServiceImpl extends BaseAdminService implements ForumPostService {
    @Resource
    private UserMapper userMapper;

    @Resource
    private ForumMapper forumMapper;

    @Resource
    private TopicMapper topicMapper;

    @Resource
    private ForumPostMapper forumPostMapper;

    @Resource
    private EditorMessageMapper editorMessageMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private AdminNewsService adminNewsService;

    @Resource
    private NewsSyncService newsSyncService;

    @Resource
    private CommonTagService commonTagService;

    @Resource
    private MixRecommendPoolService mixRecommendPoolService;

    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;

    @Resource
    private NewsSeqComponent newsSeqComponent;

    @Resource
    private PushMsgIntegService pushMsgIntegService;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Resource
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    @Resource
    private QuartzIntegrationService quartzIntegrationService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private VirtualUserMapper virtualUserMapper;

    @Resource
    private AliyunOSSService aliyunOSSService;

    @Resource
    private VirtualUserService virtualUserService;

    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;

    @Resource
    private LocationService locationService;

    @Resource
    private NewsReplyMapper newsReplyMapper;

    @Resource
    private TopicService topicService;

    @Resource
    private NewsIntegrationService newsIntegrationService;

    @Override
    public PageWarper<ForumPost> getApproveList(ForumPostParam param) {
        PageWarper<ForumPost> forumList = new PageWarper<>(forumPostMapper.getList(param));

        if (CollectionUtils.isNotEmpty(forumList.getList())) {
            forumList.getList().parallelStream().forEach(this::completePostInfo);
        }

        return forumList;
    }

    @Override
    public ForumPost selectByPrimaryKey(Long id) {
        ForumPost forumPost = forumPostMapper.selectByPrimaryKey(id);

        if (forumPost != null) {

            //填充通用属性
            this.completePostInfo(forumPost);

            //设置编辑寄语
            if (forumPost.getEditorMessageId() != null) {
                EditorMessage editorMessage = editorMessageMapper.selectByPrimaryKey(forumPost.getEditorMessageId());
                if (editorMessage != null) {
                    forumPost.setEditorMessageName(editorMessage.getTemplateName());
                }
            }

            //设置马甲号
            VirtualUserQueryParam virtualUserQueryParam = new VirtualUserQueryParam();
            virtualUserQueryParam.setId(forumPost.getUserId());
            List<VirtualUserOverviewDTO> virtualUserList = virtualUserService.list(virtualUserQueryParam);
            if (CollectionUtils.isNotEmpty(virtualUserList)) {
                forumPost.setUserInfo(virtualUserList.get(0).getUserInfo());
            }

            //设置图片
            List<PostImg> postImgList = new ArrayList<>();
            if (StringUtils.isNotBlank(forumPost.getImgList())) {
                postImgList = JSONArray.parseArray(forumPost.getImgList(), PostImg.class);
            }

            //如果没有封面，设置封面为内容中的图片
            if (StringUtils.isBlank(forumPost.getCoverList())) {
                if (CollectionUtils.isNotEmpty(postImgList)) {
                    List<String> imgList = postImgList.stream()
                            .filter(e -> StringUtils.isNotBlank(e.getType()) && "IMG".equals(e.getType()))
                            .map(PostImg::getImgUrl).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(imgList)) {
                        forumPost.setCoverList(JSONObject.toJSONString(imgList));
                    }
                }
            }

            //设置视频封面
            if (CollectionUtils.isNotEmpty(postImgList)) {
                List<String> videoList = postImgList.stream()
                        .filter(e -> StringUtils.isNotBlank(e.getType()) && "VIDEO".equals(e.getType()))
                        .map(PostImg::getImgUrl).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(videoList)) {
                    forumPost.setVideoPosterList(JSONObject.toJSONString(videoList));
                }
            }

            //填充内容
            if (StringUtils.isNotBlank(forumPost.getContent())) {
                forumPost.setContent(fixContent(forumPost.getContent()));
            }

        }

        return forumPost;
    }

    /**
     * 填充一些通用参数
     *
     * @param forumPost
     */
    private void completePostInfo(ForumPost forumPost) {
        //设置地区
        if (StringUtils.isNotEmpty(forumPost.getAreaCode())) {
            String[] areaCodeArray = forumPost.getAreaCode().split(",");
            forumPost.setAreaDetail(locationService.getAreaDetail(areaCodeArray));
        }
        //设置板块
        forumPost.setForum(forumMapper.selectByPrimaryKey(forumPost.getForumId()));
        //设置话题
        forumPost.setTopicList(topicMapper.getListByPostId(forumPost.getId()));
        //设置用户状态
        forumPost.setUserState(forumPost.getUserId() != null ? userMapper.getStateById(forumPost.getUserId()) : null);
        //设置帖子链接
        forumPost.setLinkUrl(bizConfigProperties.getH5ServerHost() + "/shareInvitationDetail.html?userId="
                + forumPost.getUserId() + "&id=" + forumPost.getId());

        restorePluginId(forumPost);
    }

    @Override
    public int approve(String ids, Byte status, String comment, Long userId) {
        List<Long> idList = Arrays.stream(ids.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }

        for (Long id : idList) {
            ForumPost forumPost = this.forumPostMapper.selectByPrimaryKey(id);
            if (null == forumPost) {
                continue;
            }

            forumPost.setStatus(status);
            //用户更新的帖子状态设置为 0(用户更新已处理)
            if (Objects.nonNull(forumPost.getIsUserUpdate()) && forumPost.getIsUserUpdate() == 1){
                forumPost.setIsUserUpdate((byte) 0);
            }

            if (3 == status) {
                //审核拒绝
                this.mixedRecommendPoolMapper.deleteByPrimaryKey(forumPost.getId());
                forumPost.setIsRecommend((byte) 0);
            } else {
                //审核通过
                //帖子设置为本地圈屏蔽和仅楼主可见时删除推荐库
                if (status == 5 || status == 6) {
                    mixedRecommendPoolMapper.deleteByPrimaryKey(forumPost.getId());
                    forumPost.setIsRecommend((byte) 0);
                }
                //为帖子增加模拟数据（点击数、点赞数）
                this.simulateData(forumPost);
                logger.debug("当前帖子[{}]审核通过：更新的信息为：[{}]", forumPost.getId(), JSON.toJSONString(forumPost));
            }
            this.forumPostMapper.updateByIdPartSelective(forumPost);
            this.forumPostMapper.addApproveHistory(sequenceCreater.nextLongId(), id, status, comment, new Date(), userId);
        }

        return 1;
    }

    /**
     * 为帖子增加模拟数据
     */
    private void simulateData(ForumPost forumPost){
        //增加点击数任务
        int count = forumPostMapper.countApproveHistory(forumPost.getId());

        //确保每个帖子只加一次
        if (count < 1) {
            //添加24小时点击数增加定时任务
            AddPostClickCountParam param = new AddPostClickCountParam();
            param.setPostId(forumPost.getId());
            if (1 == forumPost.getStatus()) {
                param.setClickCount(randomBigClickCount());
            } else {
                param.setClickCount(randomSmallClickCount());
            }
            param.setStartTime(forumPost.getDisplayTime());
        }

        //审核通过帖子增加虚拟用户点赞
        int vestCount = forumPostLikeMapper.selectByPostIdAndIsVest(forumPost.getId());
        if (vestCount < 5){
            //添加的数量
            int num = 5;
            //添加点赞开始时间
            Date date = new Date();
            //添加时间距离开始时间的毫秒值
            long difference = 7200000L;

            this.addPostLike(forumPost, num, date,difference);
        }
    }

    /**
     * 帖子添加虚拟用户点赞
     *
     * @param forumPost
     * @param num
     */
    private void addPostLike(ForumPost forumPost, Integer num,Date startTime,Long difference) {
        //获取足够多的虚拟用户id
        List<Long> exitUserId = forumPostLikeMapper.selectVirtualUserIdByPostId(forumPost.getId());
        //正式环境屏蔽本地万事通马甲号
        exitUserId.add(29211L);
        List<VirtualUser> virtualUsers = virtualUserMapper.selectRandModel(num,null,exitUserId);
        ArrayList<ForumPostLike> list = Lists.newArrayList();
        for (VirtualUser virtualUser : virtualUsers) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            //随机时间生成马甲号点赞
            int amount = (int) (1 + Math.random() * (difference));
            calendar.add(Calendar.MILLISECOND, amount);
            ForumPostLike postLike = ForumPostLike.builder()
                    .addTime(calendar.getTime())
                    .headImg(virtualUser.getHeadImg())
                    .id(nextId())
                    .isShow((byte) 0)
                    .isVest((byte) 1)
                    .postId(forumPost.getId())
                    .type((byte) 1)
                    .userId(virtualUser.getId())
                    .userNickname(virtualUser.getNickname())
                    .build();
            list.add(postLike);
        }
        //批量插入虚拟用户点赞信息
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, list).sessionTemplateName("newsSessionTemplate").run(ForumPostLikeMapper::insertSelective);
    }

    @Override
    public Message saveOrUpdate(ForumPost forumPost, Long userId) {
        //id必传
        if (null == forumPost.getId()) {
            return Message.build(false,"id未传");
        }

        //字段填充
        User user = userMapper.selectByUserId(forumPost.getUserId());
        if (null != user) {
            forumPost.setUserImg(user.getHeadImg());
            forumPost.setUserName(user.getNickname());
        }
        this.analyzeContent(forumPost);
        forumPost.setAreaCode(StringUtils.isNotBlank(forumPost.getAreaCode()) ? forumPost.getAreaCode() : null);
        forumPost.setCoverList(StringUtils.isNotBlank(forumPost.getCoverList()) ? JSON.toJSONString(forumPost.getCoverList().split(",")) : null);
        forumPost.setEditorMessage(StringUtils.isNotBlank(forumPost.getEditorMessage()) ? forumPost.getEditorMessage() : null);
        forumPost.setModifyTime(new Date());
        Long forumId = forumPost.getForumId();
        if (Objects.nonNull(forumId)){
            Forum forum = forumMapper.selectByPrimaryKey(forumId);
            forumPost.setForumContent(forum.getContent());
        }

        ForumPost existedForumPost = this.forumPostMapper.selectByPrimaryKey(forumPost.getId());
        logger.info("帖子新增或者更新，参数:[{}],原有数据:[{}]",JSONObject.toJSONString(forumPost),JSONObject.toJSONString(existedForumPost));

        buildPlugins(forumPost);

        if (null == existedForumPost) {
            forumPost.setCreateTime(new Date());
            forumPost.setCreator(userId);
            //帖子仅保存时状态设置为审核通过
            if (Objects.isNull(forumPost.getStatus())) {
                forumPost.setStatus((byte) 1);
            }
            //防止运营在帖子未生成时添加评论,并且评论已被扫描
            forumPost.setCommentCount(newsReplyMapper.count(forumPost.getId()));
            List<NewsReply> newsReplies = newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(forumPost.getId());
            if (CollectionUtils.isNotEmpty(newsReplies)) {
                forumPost.setReplyInfo(JSONObject.toJSONString(newsReplies));
            }
            int count = this.forumPostMapper.insertSelective(forumPost);
            if (count > 0) {
                this.simulateData(forumPost);
            }
        } else {
            //帖子仅保存时原状态不做修改
            if (Objects.isNull(forumPost.getStatus())) {
                forumPost.setStatus(existedForumPost.getStatus());
            }

            //状态变更，且最终状态为1，5，6时走审批流程
            if (!existedForumPost.getStatus().equals(forumPost.getStatus()) && isPostShow(forumPost.getStatus())) {
                logger.info("运营管理员[{}]对此帖子进行保存:[{}]", userId, JSONObject.toJSONString(forumPost));
                this.approve(forumPost.getId().toString(), forumPost.getStatus(), null, userId);
            }
            this.forumPostMapper.updateByIdPartSelective(forumPost);

            //帖子审核通过给用户发送(本地爆料，精华帖，现金)推送,添加小红花
            pushMessage(existedForumPost,forumPost);

			//帖子加精并且审核通过加入推荐库
			updateRecommendWhenChanged(forumPost);
        }

        this.topicService.resetForumPostTopic(forumPost.getId(),forumPost.getTopicIdList());
        this.resetForumPostTag(forumPost);
        newsIntegrationService.transcodePostVideo(forumPost.getId());
        return Message.build(true);
    }

    /**
     * 帖子审核通过给用户发送(本地爆料，精华帖，现金)推送,添加小红花
     * @param existedForumPost
     * @param forumPost
     */
    private void pushMessage(ForumPost existedForumPost, ForumPost forumPost) {
        if (forumPost.getStatus() == 1) {
            //得到推送的文案
            String forumPostTitle = getForumPostTitle(forumPost.getTitle(),forumPost.getTextField());
            //增加用户小红花
            addUserGold(forumPost, existedForumPost, forumPostTitle);
            //精华帖、现金帖推送、爆料贴推送
            pushMsg(forumPost, existedForumPost, forumPostTitle);
        }
    }

    /**
     * 帖子是否通过审核（正常显示，仅楼主可见，本地圈屏蔽）
     * @param status
     * @return
     */
    private boolean isPostShow(Byte status){
            return status == PostStatusEnum.ENABLE.getCode()
                || status == PostStatusEnum.LANDLORD.getCode()
                || status == PostStatusEnum.LOCAL_SHIELD.getCode();
    }

    /**
     * 设置组件
     * @param post
     */
    private void buildPlugins(ForumPost post){
        JSONArray json = new JSONArray();
        if(StringUtils.isNotBlank(post.getVotePluginId())){
            JSONObject votePluginJson = new JSONObject();
            votePluginJson.put("type","VOTE");
            votePluginJson.put("id",post.getVotePluginId());
            json.add(votePluginJson);

            post.setPlugins(json.toJSONString());
        }else{
            post.setPlugins("");
        }
    }

    private void restorePluginId(ForumPost post){
        if(StringUtils.isNotBlank(post.getPlugins())){
            JSONArray jsonArray = JSONArray.parseArray(post.getPlugins());
            for(int i = 0;i < jsonArray.size();i ++){
                JSONObject json = jsonArray.getJSONObject(i);
                if("VOTE".equals(json.get("type"))){
                    post.setVotePluginId(json.getString("id"));
                }
            }
        }
    }

    /**
     * 重置帖子的标签
     * @param forumPost
     */
    private void resetForumPostTag(ForumPost forumPost){
        this.forumPostMapper.deletePostTag(forumPost.getId());
        this.savePostTag(forumPost);
    }

    /**
     * 得到帖子的描述，没有标题用内容补
     *
     * @param title
     * @param textField
     * @return
     */
    @Override
    public String getForumPostTitle(String title, String textField) {
        String forumTitle = title;
        if (StringUtils.isNotBlank(forumTitle) && forumTitle.length() > 10) {
            forumTitle = forumTitle.substring(0, 10) + "...";
        } else if (StringUtils.isBlank(forumTitle)) {
            forumTitle =
                    textField.length() > 10 ? textField.substring(0, 10) + "..." : textField;
        }
        return forumTitle;
    }

    /**
     * 得到帖子的描述，没有标题用内容补
     *
     * @param title
     * @param textField
     * @return
     */
    @Override
    public String getForumPostTitleTotally(String title, String textField) {
        String forumTitle = title;
        if (StringUtils.isBlank(forumTitle)) {
            forumTitle =
                    textField.length() > 10 ? textField.substring(0, 10) + "..." : textField;
        }
        return forumTitle;
    }

    /**
     * 帖子被选为精华或爆料时,给用户增加小红花
     *
     * @param forumPost
     * @param existedForumPost
     */
    private void addUserGold(ForumPost forumPost, ForumPost existedForumPost, String forumTitle) {
        String content;
        //帖子加精
        if (existedForumPost.getIsBrilliant() != null && existedForumPost.getIsBrilliant() == 0
                && forumPost.getIsBrilliant() != null && forumPost.getIsBrilliant() == 1) {
//            Integer amount = userAccountMapper.getUserPostGold(forumPost.getUserId(), forumPost.getId(), "BRILLIANT_POST_AWARD");
//            if (null == amount || 0 == amount) {
                AccountGoldParam param = new AccountGoldParam();
                param.setUserId(forumPost.getUserId());
                param.setGold(40);
                param.setGoldType("USABLE_GOLD");
                param.setGoldFlowType("BRILLIANT_POST_AWARD");
                param.setAddTotal(true);
                param.setRelationId(forumPost.getId());
                content = "你发布的【" + forumTitle + "】被加精";
                param.setContent(content);
                userAccountIntegrationService.addGold(param);
//            }
        }
        //爆料贴
        if (existedForumPost.getIsBroke() != null && existedForumPost.getIsBroke() == 0
                && forumPost.getIsBroke() != null && forumPost.getIsBroke() == 1) {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(forumPost.getUserId());
            param.setGold(50);
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("BROKE_POST");
            param.setAddTotal(true);
            param.setRelationId(forumPost.getId());
            content = "你发布的【" + forumTitle + "】被选为爆料";
            param.setContent(content);
            userAccountIntegrationService.addGold(param);
        }
    }

    /**
     * 上传第三方图片
     * @param src
     * @return
     */
    public String uploadImgToOssBySrc(String src) {
        final RestTemplate template = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<Resource> httpEntity = new HttpEntity<>(headers);
        try {
            src = URLDecoder.decode(src, "UTF-8");
            logger.debug("src:[{}]", src);
            ResponseEntity<byte[]> response = template.exchange(src, HttpMethod.GET, httpEntity, byte[].class);
            int i = src.lastIndexOf("/");
            String fileName = src.substring(i + 1);
            fileName = RandomStringUtils.random(8, true, false) + fileName;
            return aliyunOSSService.upload(response.getBody(), fileName);
        } catch (Exception e) {
            logger.error("第三方图片上传出错", e);
        }
        return null;
    }

    @Override
    public int deleteOrRecover(String ids, Byte status, Byte deductGold) {
        List<Long> idList = Arrays.stream(ids.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }

        for (Long id : idList) {
            ForumPost forumPost = this.forumPostMapper.selectByPrimaryKey(id);
            if (forumPost == null) {
                return 0;
            }
            forumPost.setStatus(status);
            forumPost.setIsRecommend((byte) 0);
            this.forumPostMapper.updateByIdPartSelective(forumPost);

            //this.forumPostMapper.deletePostTag(id);
            if ((byte) 1 == status) {
                savePostTag(forumPost);
            } else {
                userMapper.minusPostNum(forumPost.getUserId());

                if (null != deductGold && (byte) 1 == deductGold) {
                    Integer goldNum = userAccountIntegrationService.countGoldByPostId(id, forumPost.getUserId());
                    if (null != goldNum && goldNum > 0) {
                        AccountGoldParam param = new AccountGoldParam();
                        param.setUserId(forumPost.getUserId());
                        param.setGold(-goldNum);
                        param.setGoldType("USABLE_GOLD");
                        param.setGoldFlowType("TASK_POST_DELETE");
                        param.setAddTotal(false);
                        param.setRelationId(id);
                        userAccountIntegrationService.addGold(param);
                    }
                }
                //删除推荐库中的内容
                this.mixedRecommendPoolMapper.deleteByPrimaryKey(id);
                //TODO 删除用户帖子给用户发送消息推送[pengchangqi]

            }
        }

        return 1;
    }

    @Override
    public Long getCreateId() {
        return newsSeqComponent.getPostId();
    }

    @Override
    public List<ForumPostApproveHistory> getApproveHistoryList(Long id, Integer action) {
        return forumPostMapper.getApproveHistoryList(id, action);
    }

    /**
     * 解析帖子内容
     */
    private void analyzeContent(ForumPost forumPost) {
        if (StringUtils.isNotBlank(forumPost.getContent())) {
            //提取视频和图片
            List<PostImg> postImgList = new ArrayList<>();
            List<String> imgList = new ArrayList<>();
            String content = extractVideoAndImgFromContent(forumPost.getContent(),forumPost.getVideoPosterList(), postImgList, imgList);

            List<PostImg> postImgTempList = imgList.stream().map(PostImg::buildImg).collect(Collectors.toList());
            postImgList.addAll(postImgTempList);

            forumPost.setContent(content);
            forumPost.setImgList(JSONObject.toJSONString(postImgList));

            //提取文案
            String text = HtmlContentUtils.delHtmlTags(content);
            forumPost.setTextField(text);
        }
    }

    @Override
    public String extractVideoAndImgFromContent(String content, String videoPosterStr, List<PostImg> postImgList, List<String> imgList) {

        Document document = Jsoup.parse(content);
        document.outputSettings().prettyPrint(true).indentAmount(1);

        //处理视频
        dealWithVideo(document,postImgList);

        //处理图片并提取
        dealWithImg(document,imgList);

        return document.body().html().replace("\n", "");
    }

    private void dealWithVideo(Document document,List<PostImg> postImgList){
        Elements elements = document.select("video");
        if (null != elements) {
            for (Element element : elements) {
                String src = element.attr("src");
                if (StringUtils.isBlank(src)) {
                    continue;
                }
                String poster = element.attr("poster");
                if (StringUtils.isEmpty(poster)) {
                    String url = src;
                    int lastIndex = src.lastIndexOf("?");
                    if (-1 != lastIndex) {
                        url = src.substring(0, lastIndex);
                    }
                    String baseName = FilenameUtils.getBaseName(url);

                    KeyGenerator videoCacheKey = DefaultKeyGenerator.build("cache", "static", "videoinfo");
                    @SuppressWarnings("unchecked")
                    Map<String, Object> videoCacheInfo = redisHashMapAdapter.get(videoCacheKey, baseName, Map.class);
                    if (videoCacheInfo != null && !videoCacheInfo.isEmpty()) {
                        String size = videoCacheInfo.get("size") == null ? "0" : videoCacheInfo.get("size").toString();
                        String duration = videoCacheInfo.get("duration") == null ? "0" : videoCacheInfo.get("duration").toString();
                        String imgUrl = videoCacheInfo.get("imgUrl") == null ? "" : videoCacheInfo.get("imgUrl").toString();
                        element.attr("poster", imgUrl);
                        element.attr("size", size);
                        element.attr("duration", duration);
                        logger.debug("video标签经处理后:{}", element.html());
                    }
                }

                PostImg img = new PostImg();
                img.setType("VIDEO");
                img.setImgUrl(element.attr("poster"));
                img.setVideoUrl(element.attr("src"));
                img.setSize(element.attr("size") == null ? "0" : element.attr("size"));
                img.setDuration(element.attr("duration") == null ? 0 : NumberUtils.toLong(element.attr("duration"),0));
                postImgList.add(img);
            }
        }
    }

    /**
     * 处理图片，将第三方图片上传至服务器，将图片收集至list
     * @param document
     * @param imgList
     */
    private void  dealWithImg(Document document, List<String> imgList) {
        Elements imgElements = document.select("img");
        if (null != imgElements) {
            for (Element element : imgElements) {
                boolean isExist = true;
                String src = element.attr("src");
                if (org.apache.commons.lang.StringUtils.isBlank(src)) {
                    isExist = false;
                    src = element.attr("data-src");
                    if (org.apache.commons.lang.StringUtils.isNotBlank(src)) {
                        isExist = true;
                    }
                }
                if (isExist) {
                    if (!src.contains("wstong.com")) {
                        src = uploadImgToOssBySrc(src);
                        if (null == src) {
                            continue;
                        }
                        element.attr("src", src);
                    }

                    int lastIndex = src.lastIndexOf("?");
                    if (-1 != lastIndex) {
                        src = src.substring(0, lastIndex);
                        element.attr("src", src);
                    }

                    imgList.add(src);
                } else {
                    element.remove();
                }

            }
        }
    }

    /**
     * 处理内容，将图片加上样式
     * @param content
     * @return
     */
    private String fixContent(String content) {
        Document document = Jsoup.parse(content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        Elements elements = document.select("img");
        if (null != elements) {
            for (Element element : elements) {
                String src = element.attr("src");
                if (org.apache.commons.lang.StringUtils.isBlank(src)) {
                    src = element.attr("data-src");
                    if (org.apache.commons.lang.StringUtils.isBlank(src)) {
                        continue;
                    }
                }
                String url = src;
                int lastIndex = src.lastIndexOf("?");
                if (-1 != lastIndex) {
                    url = src.substring(0, lastIndex);
                }
                url += "?x-oss-process=style/mcompress";
                element.attr("src", url);
            }
        }
        return document.body().html().replace("\n", "");
    }

    @Override
    public Json transformPost2News(Long id) {
        ForumPost forumPost = forumPostMapper.selectByPrimaryKey(id);
        if (StringUtils.isEmpty(forumPost.getAreaCode())||forumPost.getStatus()!=1) {
            return ResultUtil.genFailedResult("帖子投放区域为'全国'，不支持转本地新闻 或者 帖子状态异常");
        }
        NewsAddParam newsAddParam = new NewsAddParam();
        newsAddParam.setId(newsSeqComponent.getNewsId());
        if (StringUtils.isNotBlank(forumPost.getTitle())) {
            newsAddParam.setTitle(forumPost.getTitle());
        } else {
            if (forumPost.getTextField().length() > 10) {
                newsAddParam.setTitle(forumPost.getTextField().substring(0, 10));
            } else {
                newsAddParam.setTitle(forumPost.getTextField());
            }
        }
        newsAddParam.setContent(forumPost.getContent());

        String coverList = forumPost.getCoverList();
        if (StringUtils.isNotEmpty(coverList)) {
            List<String> list = JSONObject.parseArray(coverList, String.class);
            newsAddParam.setCoverList(StringUtils.join(list, ","));
        }
        newsAddParam.setAuthor(forumPost.getUserName());
        newsAddParam.setKindId(0);
        newsAddParam.setStatus(NewsStatusEnum.ENABLE.getCode());
        newsAddParam.setReviewStatus(NewsStatusEnum.UNREVIEWED.getCode());
        if (null != forumPost.getPublishTime()) {
            newsAddParam.setPublishTime(forumPost.getPublishTime());
            newsAddParam.setStatus(NewsStatusEnum.UNPUBLISHED.getCode());
        }
        newsAddParam.setTop((byte) 1);
        newsAddParam.setHot((byte) 1);
        newsAddParam.setIsBootDownload((byte) 0);
        if (StringUtils.isNotEmpty(forumPost.getAreaCode())) {
            newsAddParam.setAreaCodes(forumPost.getAreaCode());
            newsAddParam.setDeliveryType(1);
        } else {
            newsAddParam.setAreaCodes(null);
            newsAddParam.setDeliveryType(0);
        }
        newsAddParam.setKindTop((byte) 1);
        newsAddParam.setIssueTime(forumPost.getDisplayTime());
        newsAddParam.setEnablePlaceholder(forumPost.getEnablePlaceholder());
        newsAddParam.setEditorMessageId(forumPost.getEditorMessageId());
        newsAddParam.setEditorMessage(forumPost.getEditorMessage());
        return adminNewsService.addNews(newsAddParam);
    }

    /**
     * 推送消息
     * @param forumPost
     * @param existedForumPost
     * @param forumTitle
     */
    private void pushMsg(ForumPost forumPost, ForumPost existedForumPost, String forumTitle) {
        //精华帖推送
        if (existedForumPost.getIsBrilliant() != null && existedForumPost.getIsBrilliant() == 0
                && forumPost.getIsBrilliant() != null && forumPost.getIsBrilliant() == 1) {
            String content = "恭喜！你发布的【" + forumTitle + "】被加精，奖励你40朵小红花，你的内容将会被更多人看到哦~";
            PushMessage message = getPushMessage(PushMessageEnum.ESSENCE_POST, forumPost, content);
            this.pushMsgIntegService.pushMsg(message);
        }

        //现金帖推送
        if (existedForumPost.getIsCash() != null && existedForumPost.getIsCash() == 0
                && forumPost.getIsCash() != null && forumPost.getIsCash() == 1) {
            String content = "速来领钱！你发布的【" + forumTitle + "】获得了现金奖励，请快快联系我们领取！";
            PushMessage message = getPushMessage(PushMessageEnum.CASH_POST, forumPost, content);
            this.pushMsgIntegService.pushMsg(message);
        }

        //爆料贴推送
        if (existedForumPost.getIsBroke() != null && existedForumPost.getIsBroke() == 0
                && forumPost.getIsBroke() != null && forumPost.getIsBroke() == 1) {
            String content = "恭喜！你发布的【" + forumTitle + "】被选为爆料内容，奖励你50朵小红花。";
            PushMessage message = getPushMessage(PushMessageEnum.BROKE_POST, forumPost, content);
            this.pushMsgIntegService.pushMsg(message);
        }
    }

    /**
     * 获得帖子推送对象
     *
     * @param pushMessageEnum
     * @param forumPost
     * @param content
     * @return
     */
    private PushMessage getPushMessage(PushMessageEnum pushMessageEnum, ForumPost forumPost, String content) {
        PushPayloadInfo info = PushPayloadInfo.build(pushMessageEnum);
        Long msgId = nextId();
        info.setMsgId(msgId);
        info.addExtend("msgId", msgId);
        info.addExtend("url", bizConfigProperties.getH5ServerHost() + "/servicePrize.html?areaCode=" + forumPost.getAreaCode());
        info.addExtend("postId", forumPost.getId());
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(forumPost.getUserId()));
        message.setPayloadInfo(info);
        return message;
    }

    /**
     * 获取分词标签并保存
     * @param forumPost
     */
    private void savePostTag(ForumPost forumPost) {
        if(!bizConfigProperties.getEnablePostTagParse()){
            return ;
        }
        PendingContent pendingContent = new PendingContent();
        pendingContent.setTitle(forumPost.getTitle());
        pendingContent.setContent(forumPost.getContent());
        ResponseEntity<List<Keyword>> responseEntity = newsSyncService.analysisContent(pendingContent);
        if (responseEntity.getStatusCode().isError()) {
            return;
        }

        List<Keyword> tagList = responseEntity.getBody();
        if (CollectionUtils.isNotEmpty(tagList)) {
            for (Keyword keyword : tagList) {
                PostTag postTag = new PostTag();
                postTag.setId(sequenceCreater.nextLongId());
                postTag.setName(keyword.getName());
                postTag.setTagType(NewsTagTypeEnum.TITLE_TAG.getCode());
                postTag.setWeight(keyword.getTfidfvalue());
                postTag.setPostId(forumPost.getId());
                postTag.setTagId(commonTagService.saveAndGetTag(keyword.getName()));
                forumPostMapper.savePostTag(postTag);
            }
        }
    }

    /**
     * 更新推荐池内容
     * 当目前状态是<正常显示>时，更新在推荐库中的内容
     * 否则删除在推荐库中的内容
     * @param forumPost
     */
    private void updateRecommendWhenChanged(ForumPost forumPost) {

        Byte isBrilliant = forumPost.getIsBrilliant();
        Byte status = forumPost.getStatus();
        MixedRecommendPool result = mixedRecommendPoolMapper.selectByPrimaryKey(forumPost.getId());
        //审核通过状态
        if (NewsStatusEnum.ENABLE.getCode().equals(status)) {
            if (Objects.nonNull(result)) {
                Byte auto = result.getAuto();
                if (isBrilliant == 0 && (Objects.isNull(auto) || auto == 0)) {
                    //当推荐池是自动加入时,取消精华帖删除推荐池数据
                    mixedRecommendPoolMapper.deleteByPrimaryKey(result.getId());
                } else {

                    MixedRecommendPool mixedRecommendPool = MixedRecommendPool.builder()
                            .id(forumPost.getId())
                            .title(forumPost.getTitle())
                            .issueTime(forumPost.getDisplayTime())
                            .publishTime(forumPost.getPublishTime())
                            .author(forumPost.getUserName())
                            .userId(forumPost.getUserId())
                            .areaDetail(StringUtils.isNotBlank(forumPost.getAreaCode()) ? forumPost.getAreaCode() : null)
                            .weight(result.getWeight())
                            .auto(result.getAuto())
                            .recommendTime(result.getRecommendTime())
                            .optimizationNotice(result.getOptimizationNotice())
                            .deliveryType(forumPost.getDeliveryType())
                            .origin(MixRecommendTypeEnum.MIX_POST.getCode()).build();
                    mixRecommendPoolService.updateMixRecommend(mixedRecommendPool);
                }
            } else {
                //精华帖并且审核通过加入推荐库
                if (isBrilliant == 1) {
                    mixRecommendPoolService.addPostToRecommendPoolAuto(forumPost);
                }
            }
        } else {
            //删除推荐库
            if (Objects.nonNull(result)) {
                mixedRecommendPoolMapper.deleteByPrimaryKey(result.getId());
            }
        }
    }

    private long randomBigClickCount() {
        return 2000L + new Random().nextInt(4000);
    }

    private long randomSmallClickCount() {
        return 1500L + new Random().nextInt(1000);
    }

    @Override
    public Message doAddPostLike(Long postId, Date startTime, Date endTime, Integer num) {
        ForumPost forumPost = forumPostMapper.selectByPrimaryKey(postId);
        if (Objects.nonNull(forumPost)){
            Long difference = endTime.getTime() - startTime.getTime();
            addPostLike(forumPost,num,startTime,difference);
        }
        return Message.build(true);
    }
}
