package com.bxm.localnews.admin.service.forum.impl;

import com.bxm.localnews.admin.param.NewsReplyOriginalParam;
import com.bxm.localnews.admin.param.ReplyCategoryParam;
import com.bxm.localnews.admin.param.ReplyLibraryParam;
import com.bxm.localnews.admin.param.ReplyOriginalParam;
import com.bxm.localnews.admin.service.forum.ReplyLibraryCategoryService;
import com.bxm.localnews.admin.service.forum.ReplyLibraryService;
import com.bxm.localnews.admin.service.news.AdminNewsReplyService;
import com.bxm.localnews.admin.vo.ReplyLibrary;
import com.bxm.localnews.admin.vo.ReplyLibraryCategory;
import com.bxm.localnews.news.domain.ReplyLibraryCategoryMapper;
import com.bxm.localnews.news.domain.ReplyLibraryMapper;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class ReplyLibraryServiceImpl implements ReplyLibraryService {

    @Resource
    private ReplyLibraryMapper replyLibraryMapper;

    @Resource
    private AdminNewsReplyService adminNewsReplyService;

    @Override
    public PageWarper<ReplyLibrary> getList(ReplyLibraryParam param) {
        return new PageWarper<>(replyLibraryMapper.getList(param));
    }

    @Override
    public ReplyLibrary selectByPrimaryKey(Long id) {
        return replyLibraryMapper.selectByPrimaryKey(id);
    }

    @Override
    public int batchInsert(List<ReplyLibrary> replyLibraryList) {
        if (CollectionUtils.isEmpty(replyLibraryList)) {
            return 0;
        }

        return replyLibraryMapper.batchInsert(replyLibraryList);
    }

    @Override
    public int updateByPrimaryKey(ReplyLibrary replyLibrary) {
        return replyLibraryMapper.updateByPrimaryKey(replyLibrary);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return replyLibraryMapper.deleteByPrimaryKey(id);
    }

    @Override
    public void generateVirtualReply(ReplyOriginalParam param) {
        if (null == param || CollectionUtils.isEmpty(param.getReplyLibraryCategoryList())) {
            return;
        }

        List<NewsReplyOriginalParam.Reply> replyList = new ArrayList<>();
        for (ReplyLibraryCategory replyLibraryCategory : param.getReplyLibraryCategoryList()) {
            List<String> replyStringList = replyLibraryMapper.getRandList(replyLibraryCategory.getId(), replyLibraryCategory.getReplyCount());

            if (CollectionUtils.isNotEmpty(replyStringList)) {
                for (String replyStr : replyStringList) {
                    NewsReplyOriginalParam.Reply reply = new NewsReplyOriginalParam.Reply();
                    reply.setContent(replyStr);
                    replyList.add(reply);
                }
            }
        }

        NewsReplyOriginalParam replyParam = new NewsReplyOriginalParam();
        replyParam.setNewsId(param.getNewsId());
        replyParam.setStartTime(param.getStartTime());
        replyParam.setEndTime(param.getEndTime());
        replyParam.setList(replyList);
        adminNewsReplyService.doGenerateReply(replyParam);
    }

    @Override
    public List<ReplyLibrary> getReplyByCategoryId(ReplyCategoryParam param) {
        return replyLibraryMapper.getRandListByCategoryId(param);
    }
}
