package com.bxm.localnews.admin.service.im;

import com.bxm.localnews.admin.dto.im.ChatRoomMessageDTO;
import com.bxm.localnews.admin.param.ChatRoomQueryParam;
import com.bxm.localnews.admin.param.ImMessageQueryParam;
import com.bxm.localnews.admin.vo.im.HistoryChatBean;
import com.bxm.localnews.admin.vo.im.ImMessageBean;
import com.bxm.newidea.component.vo.PageWarper;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 即时通讯相关服务
 * @author liujia
 */
public interface IMService {
    /**
     * 查询聊天记录
     * @param param 查询参数
     * @return 聊天记录列表
     */
    List<ImMessageBean> query(ImMessageQueryParam param);

    /**
     * 查询用户的历史聊天记录
     * @param userId 用户ID
     * @return 历史聊天对象
     */
    List<HistoryChatBean> queryHistory(Long userId);

    void getVoiceByContent(String content, HttpServletResponse response);

    PageWarper<ChatRoomMessageDTO> queryChatRoomRecord(ChatRoomQueryParam param);

    Boolean createChatRoom(String areaCode);
}
