package com.bxm.localnews.admin.service.im.impl;

import com.bxm.localnews.admin.config.ImChatRoomProperties;
import com.bxm.localnews.admin.domain.IMMapper;
import com.bxm.localnews.admin.domain.LocationMapper;
import com.bxm.localnews.admin.dto.im.ChatRoomMessageDTO;
import com.bxm.localnews.admin.integration.IMIntegrationService;
import com.bxm.localnews.admin.param.ChatRoomQueryParam;
import com.bxm.localnews.admin.param.ImMessageQueryParam;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.service.im.IMService;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.localnews.admin.vo.im.HistoryChatBean;
import com.bxm.localnews.admin.vo.im.ImMessageBean;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.joda.time.DateTimeComparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class IMServiceImpl extends BaseService implements IMService {

    private final IMMapper imMapper;
    private final LocationMapper locationMapper;
    private final ImChatRoomProperties imChatRoomProperties;
    private final IMIntegrationService imIntegrationService;

    private DateTimeComparator dateTimeComparator = DateTimeComparator.getInstance();

    @Autowired
    public IMServiceImpl(IMMapper imMapper,LocationMapper locationMapper,
                         ImChatRoomProperties imChatRoomProperties,
                         IMIntegrationService imIntegrationService) {
        this.imMapper = imMapper;
        this.locationMapper = locationMapper;
        this.imChatRoomProperties = imChatRoomProperties;
        this.imIntegrationService = imIntegrationService;
    }

    @Override
    public List<ImMessageBean> query(ImMessageQueryParam param) {
        Preconditions.checkArgument(param != null);

        List<ImMessageBean> result = Lists.newArrayList();

        if (null != param.getSender() && null != param.getReceiver()) {
            result.addAll(imMapper.query(param));

            long sender = param.getSender();
            param.setSender(param.getReceiver());
            param.setReceiver(sender);
            result.addAll(imMapper.query(param));

            result = result.stream().sorted((pre, next) ->
                    dateTimeComparator.compare(next.getSendTime(), pre.getSendTime()))
                    .collect(Collectors.toList());
        } else {
            result = imMapper.query(param);
        }

        return result;
    }

    @Override
    public List<HistoryChatBean> queryHistory(Long userId) {
        return imMapper.queryHistory(userId);
    }

    @Override
    public void getVoiceByContent(String id, HttpServletResponse response) {

        response.setCharacterEncoding("utf-8");
        response.setContentType("multipart/form-data");
        response.setHeader("Content-Disposition", "attachment;fileName=" + id + ".amr");
        String content = imMapper.selectContentById(id);
        try(OutputStream out = response.getOutputStream()){
            byte[] audioByte = Base64.decode(content);
            out.write(audioByte);
            out.flush();
        }catch (Exception e){
            logger.error("下载文件错误",e);
        }

    }

    @Override
    public PageWarper<ChatRoomMessageDTO> queryChatRoomRecord(ChatRoomQueryParam param) {

        Map<String, Location> locationMap = SpringContextHolder.getBean(LocationService.class).listLocation();
        PageWarper<ChatRoomMessageDTO> result = new PageWarper<ChatRoomMessageDTO>(imMapper.queryChatRoomRecord(param));
        result.getList().forEach(e->{
            String areaCode = e.getAreaCode();
            Location location = locationMap.get(areaCode);
            if (Objects.nonNull(location)){
                e.setAreaName(location.getName());
            }
        });

        return result;
    }

    @Override
    public Boolean createChatRoom(String areaCode) {
        Long assistantUserId = imChatRoomProperties.getChatRoomTimingRedPacketAssistantUserId();
        Location location = locationMapper.selectByCode(areaCode);
        Boolean chatRoom = imIntegrationService.createChatRoom(areaCode, assistantUserId, location.getName());

        return chatRoom;
    }

}
