package com.bxm.localnews.admin.service.market.impl;

import com.bxm.localnews.admin.domain.MarketOrderMapper;
import com.bxm.localnews.admin.enums.MarketCommodityTypeEnum;
import com.bxm.localnews.admin.param.MarketOrderQueryParam;
import com.bxm.localnews.admin.service.market.MarketOrderService;
import com.bxm.localnews.admin.util.ExportUtils;
import com.bxm.localnews.admin.util.dto.ExportDataRow;
import com.bxm.localnews.admin.util.dto.ExportModel;
import com.bxm.localnews.admin.vo.MarketOrder;
import com.bxm.localnews.admin.vo.MarketOrderExpressage;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import com.bxm.newidea.component.tools.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

@Service
public class MarketOrderServiceImpl implements MarketOrderService {
    private static final Logger logger = LoggerFactory.getLogger(MarketOrderServiceImpl.class);

    @Resource
    private MarketOrderMapper marketOrderMapper;

    @Override
    public PageWarper<MarketOrder> getList(MarketOrderQueryParam param) {
        return new PageWarper<>(marketOrderMapper.getList(param));
    }

    @Override
    public int saveOrUpdate(MarketOrderExpressage marketOrderExpressage) {
        if (null == marketOrderExpressage.getId()) {
            return 0;
        } else {
            MarketOrder order = new MarketOrder();
            order.setId(marketOrderExpressage.getId());
            order.setStatus(0);
            order.setExpressageCompany(marketOrderExpressage.getExpressageCompany());
            order.setExpressageNo(marketOrderExpressage.getExpressageNo());
            return marketOrderMapper.updateByPrimaryKeySelective(order);
        }
    }

    @Override
    public void exportExcel(MarketOrderQueryParam param, HttpServletResponse response) {
        param.setPageSize(0);
        List<MarketOrder> orderList = marketOrderMapper.getList(param);

        try {
            String fileName = "兑换订单列表.xls";
            String headNames = "订单编号,用户id,用户昵称,商品名称,兑换类型,订单状态,创建时间,收货信息,物流单号,物流公司";

            // 构造excel数据模型
            ExportModel exportModel = new ExportModel();
            exportModel.setHeadNames(headNames);

            List<ExportDataRow> dataRowList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(orderList)) {
                for (MarketOrder order : orderList) {
                    ExportDataRow exportDataRow = new ExportDataRow();
                    List<String> dataColumnList = new ArrayList<>();

                    dataColumnList.add(order.getOrderNo());
                    dataColumnList.add(order.getUserId() + "");
                    dataColumnList.add(order.getUserName());
                    dataColumnList.add(order.getCommodityTitle());
                    dataColumnList.add(MarketCommodityTypeEnum.valueOf(order.getCommodityType()).getDesc());
                    if (null == order.getStatus()) {
                        dataColumnList.add("");
                    } else if (0 == order.getStatus()) {
                        dataColumnList.add("待扣除");
                    } else if (1 == order.getStatus()) {
                        dataColumnList.add("已完成");
                    } else if (2 == order.getStatus()) {
                        dataColumnList.add("余额不足");
                    }
                    dataColumnList.add(DateUtils.formatDateTime(order.getCreateTime()));
                    dataColumnList.add(order.getFinalAddress());
                    dataColumnList.add(order.getExpressageNo());
                    dataColumnList.add(order.getExpressageCompany());

                    exportDataRow.setDataColumnList(dataColumnList);
                    dataRowList.add(exportDataRow);
                }
            }
            exportModel.setDataRowList(dataRowList);

            byte[] result = ExportUtils.makeExcel(exportModel, fileName);
            ExportUtils.exportToResponse(response, fileName, result, "excel");
        } catch (Exception e) {
            logger.error("导出兑换订单失败：", e);
        }
    }
}
