package com.bxm.localnews.admin.service.news;

import com.bxm.localnews.admin.param.NewsMonitorConditionParam;
import com.bxm.localnews.admin.param.NewsMonitorParam;
import com.bxm.localnews.admin.vo.NewsMonitorBean;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 新闻监控指标服务接口
 */
public interface NewsMonitorService {

    /**
     * 分页获取监控指标
     * @param param 查询参数
     * @return 分页结果
     */
    PageWarper<NewsMonitorBean> queryByParam(NewsMonitorParam param);

    /**
     * 保存新闻监控指标
     * 根据监控指标细则配置对应的定时任务,新增编辑时进行对应的处理
     * @param param 指标保存参数
     * @return 保存结果
     */
    Message save(NewsMonitorConditionParam param);

    /**
     * 获取监控指标详情
     * @param id 指标ID
     * @return 指标详情
     */
    NewsMonitorBean get(Long id);

    /**
     * 移除监控指标
     * @param id 指标ID
     * @return 移除结果
     */
    Message remove(Long id);
}
