package com.bxm.localnews.admin.service.news;

import com.bxm.localnews.admin.param.NewsDetailStatisticsParam;
import com.bxm.localnews.admin.param.NewsSourceStatisticsParam;
import com.bxm.localnews.admin.vo.NewsSourceInfoBean;

import java.util.List;

/**
 * 新闻来源统计
 * @author liujia
 */
public interface NewsSourceStatisticsService {

    /**
     * 根据条件查询新闻区域统计信息
     * @param param 查询条件
     * @return 统计结果
     */
    List<NewsSourceInfoBean> query(NewsSourceStatisticsParam param);

    /**
     * 刃甲条件查询新闻来源统计信息
     * @param param 查询条件
     * @return 统计结果
     */
    List<NewsSourceInfoBean> queryDetail(NewsDetailStatisticsParam param);
}
