package com.bxm.localnews.admin.service.news.impl;

import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.convert.impl.CommentReplyConverter;
import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.dto.NewsDetailDTO;
import com.bxm.localnews.admin.dto.ReplyDTO;
import com.bxm.localnews.admin.dto.ReplyDetailDTO;
import com.bxm.localnews.admin.integration.NewsElasticIntegrationService;
import com.bxm.localnews.admin.integration.NewsIntegrationService;
import com.bxm.localnews.admin.param.AllReplyParam;
import com.bxm.localnews.admin.param.CommentReplyParam;
import com.bxm.localnews.admin.param.NewsReplyOriginalParam;
import com.bxm.localnews.admin.param.NewsReplyParam;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.service.news.AdminNewsReplyService;
import com.bxm.localnews.admin.vo.*;
import com.bxm.localnews.news.domain.*;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
public class AdminNewsReplyServiceImpl extends BaseService implements AdminNewsReplyService {

    @Autowired
    private VirtualUserMapper virtualUserMapper;

    @Autowired
    private NewsReplyMapper newsReplyMapper;

    @Autowired
    private AdminNewsMapper newsMapper;

    @Autowired
    private UserReplyMapper userReplyMapper;

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private CommentReplyConverter commentReplyConverter;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    @Autowired
    private VirtualUserService virtualUserService;

    @Autowired
    private AllReplyMapper allReplyMapper;

    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Autowired
    private NewsElasticIntegrationService newsElasticIntegrationService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void doGenerateReply(NewsReplyOriginalParam newsReplyOriginalParam) {

        Long newsId = newsReplyOriginalParam.getNewsId();
        String newsIdStr = newsId.toString();
        List<Long> userIdList = newsReplyMapper.selectUserFromReply(newsId);

        List<NewsReplyOriginalParam.Reply> replyList = newsReplyOriginalParam.getList();

        List<VirtualUser> virtualUserList =virtualUserMapper.selectRandModel(replyList.size()+10, (byte) 1,userIdList);
        if (CollectionUtils.isEmpty(virtualUserList)) {
            return ;
        }

        long startTime = newsReplyOriginalParam.getStartTime().getTime();
        long endTime = newsReplyOriginalParam.getEndTime().getTime();

        if (startTime>endTime) {
            return;
        }

        int index = 0;
        int virtualUserCount = virtualUserList.size();
        for (NewsReplyOriginalParam.Reply reply:replyList) {

            if (index > virtualUserCount-1) {
                index = (int) (Math.random()* virtualUserCount);

            }

            VirtualUser virtualUser  = virtualUserList.get(index);
            long indexTime = RandomUtils.nextLong(startTime,endTime);

            NewsReply newsReply = new NewsReply();
            newsReply.setAddTime(new Date(indexTime));
            newsReply.setDeleteFlag((byte) 0);
            newsReply.setHeadImg(virtualUser.getHeadImg());
            newsReply.setId(nextSequence());
            newsReply.setLevel((byte) 0);
            newsReply.setLikeCount(0);
            newsReply.setNewsId(newsReplyOriginalParam.getNewsId());
            newsReply.setReplyContent(reply.getContent());
            //如果是帖子
            if (newsIdStr.startsWith("4") && newsIdStr.length() == 16) {
                newsReply.setType((byte) 3);
            //如果是新闻
            } else {
                newsReply.setType((byte) 1);
            }
            newsReply.setParentId(0L);
            //都设置为待展示，等待扫描
            newsReply.setStatus((byte) 0);
            newsReply.setUserId(virtualUser.getId());
            newsReply.setUserNickname(virtualUser.getNickname());
            newsReply.setInteractiveCount(0);
            newsReply.setRootId(0L);
            newsReplyMapper.insertSelective(newsReply);
            userReplyMapper.insertUserReplySelective(newsReply);
            index++;
        }

        int count = newsReplyMapper.count(newsReplyOriginalParam.getNewsId());
        logger.info("虚拟评论生成，已有评论数:{},新闻/帖子id:{}",count,newsReplyOriginalParam.getNewsId());
        //如果是帖子
        if (newsIdStr.startsWith("4") && newsIdStr.length() == 16) {
            forumPostMapper.updateComment(newsReplyOriginalParam.getNewsId(),count);
        //如果是新闻
        } else {
            newsMapper.updateComment(newsReplyOriginalParam.getNewsId(),count);
        }
    }

    @Override
    public void delReply(Long id,Long newsId) {
        NewsReply newsReply = newsReplyMapper.selectByPrimaryKey(id, newsId);
        if (newsReply != null) {
            //调用新闻服务删除评论接口
            newsIntegrationService.delReply(newsReply.getId(),newsReply.getUserId(),newsReply.getNewsId());
        }
    }

    @Override
    public PageWarper<NewsReply> listNewsReply(NewsReplyParam newsReplyParam) {
        PageWarper<NewsReply> newsReplyPageWarper = new PageWarper<>(newsReplyMapper.queryByPageSize(newsReplyParam));
        List<NewsReply> newsReplyList = newsReplyPageWarper.getList();
        if (CollectionUtils.isNotEmpty(newsReplyList)) {
            Map<Long,VirtualUser> longVirtualUserMap = virtualUserService.list();
            newsReplyList.parallelStream().forEach(e->{
                e.setIsVirtualParentUser((byte) ((null != e.getParentUserId() && longVirtualUserMap.containsKey(e.getParentUserId()))?1:0));
                e.setIsVirtualUser((byte) ((null != e.getUserId() && longVirtualUserMap.containsKey(e.getUserId()))?1:0));
            });
        }

        return newsReplyPageWarper;
    }

    @Override
    public int doAddCommentReply(CommentReplyParam commentReplyParam) {
        //参数转化成实体
        NewsReply newsReply = commentReplyConverter.convert(commentReplyParam);
        //用户评论表
        userReplyMapper.insertUserReplySelective(newsReply);
        //新闻评论表
        int result = newsReplyMapper.insertSelective(newsReply);

        return result;
    }

    @Override
    public PageWarper<ReplyDTO> listAllNewsReply(AllReplyParam allReplyParam) {
        //兼容客户端搜索评论的正常状态
        if (Objects.nonNull(allReplyParam.getIsUserDelete()) && allReplyParam.getIsUserDelete() == 2){
            allReplyParam.setIsUserDelete(null);
            allReplyParam.setDeleteFlag((byte) 0);
        }

        List<ReplyDTO> replyDTOS = allReplyMapper.listAllNewsReply(allReplyParam);
        LocationService locationService = SpringContextHolder.getBean(LocationService.class);
		Map<Long,VirtualUser> longVirtualUserMap = virtualUserService.list();
		replyDTOS.forEach(e->{
            if (StringUtils.isNotEmpty(e.getAreaCode())) {
                String[] areaCodeArray = e.getAreaCode().split(",");
                e.setAreaDetail(locationService.getAreaDetail(areaCodeArray));
            }
            e.setLinkUrl(bizConfigProperties.getH5ServerHost() + "/shareInvitationDetail.html?userId="
                    + e.getUserId() + "&id=" + e.getNewsId());
            e.setIsVirtualParentUser((byte) ((null != e.getParentUserId() && longVirtualUserMap.containsKey(e.getParentUserId()))? 1 : 0));
            e.setIsVirtualUser((byte) ((null != e.getUserId() && longVirtualUserMap.containsKey(e.getUserId())) ? 1 : 0));
        });
        PageWarper<ReplyDTO> newsReplyPageWarper = new PageWarper<ReplyDTO>(replyDTOS);
        return newsReplyPageWarper;
    }

    @Override
    public ReplyDetailDTO getReplyDetail(Long newsId, Long replyId) {
        Map<Long,VirtualUser> longVirtualUserMap = virtualUserService.list();
        NewsReply newsReply = newsReplyMapper.selectByPrimaryKey(replyId, newsId);
        //判断评论是否是跟评论,不是则找出根评论
        if (newsReply.getRootId() != 0) {
            newsReply = newsReplyMapper.selectByPrimaryKey(newsReply.getRootId(), newsId);
        }
        newsReply.setIsVirtualParentUser((byte) ((null != newsReply.getParentUserId() && longVirtualUserMap.containsKey(newsReply.getParentUserId()))? 1 : 0));
        newsReply.setIsVirtualUser((byte) ((null != newsReply.getUserId() && longVirtualUserMap.containsKey(newsReply.getUserId())) ? 1 : 0));

        ReplyDetailDTO replyDetailDTO = new ReplyDetailDTO();
        BeanUtils.copyProperties(newsReply,replyDetailDTO);
        //查找根评论
        List<NewsReply>  childs = newsReplyMapper.selectByRootId(newsReply.getId(), newsReply.getNewsId());
        childs.forEach(e->{
            e.setIsVirtualParentUser((byte) ((null != e.getParentUserId() && longVirtualUserMap.containsKey(e.getParentUserId()))? 1 : 0));
            e.setIsVirtualUser((byte) ((null != e.getUserId() && longVirtualUserMap.containsKey(e.getUserId())) ? 1 : 0));
        });
        replyDetailDTO.setList(childs);
        //组装帖子或者新闻
        Byte type = newsReply.getType();
        if (type == 3){
            ForumPost forumPost = forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
            forumPost.setLinkUrl(bizConfigProperties.getH5ServerHost() + "/shareInvitationDetail.html?userId="
                    + forumPost.getUserId() + "&id=" +forumPost.getId());
            replyDetailDTO.setForumPost(forumPost);
        }else if (type == 1){
            NewsDetailDTO newsDetailDTO = newsElasticIntegrationService.getNewsFromES(newsReply.getNewsId());
            News  news = new News();
            BeanUtils.copyProperties(newsDetailDTO,news);
            news.setLinkUrl(bizConfigProperties.getH5ServerHost() + "/newsDetail.html?newsId=" + news.getId() + "&userId=" + "&type=1");
            replyDetailDTO.setNews(news);

        }
        return replyDetailDTO;
    }
}
