package com.bxm.localnews.admin.service.news.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.MarketingActivitiesDeliveryTypeEnum;
import com.bxm.localnews.admin.constant.MixRecommendTypeEnum;
import com.bxm.localnews.admin.constant.NewsStatusEnum;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.convert.impl.AdminNewsPageConverter;
import com.bxm.localnews.admin.convert.impl.NewsConverter;
import com.bxm.localnews.admin.dto.*;
import com.bxm.localnews.admin.enums.ShowLevelEnum;
import com.bxm.localnews.admin.integration.NewsElasticIntegrationService;
import com.bxm.localnews.admin.integration.NewsIntegrationService;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.seq.NewsSeqComponent;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.service.SpiderManageService;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.service.forum.ForumPostService;
import com.bxm.localnews.admin.service.news.AdminNewsService;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.admin.service.security.BaseAdminService;
import com.bxm.localnews.admin.vo.*;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.domain.*;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhaoyadong 2018/10/16 9:22
 * @desc
 */
@Service
@RefreshScope
public class AdminNewsServiceImpl extends BaseAdminService implements AdminNewsService {

    private NewsSeqComponent newsSeqComponent;

    private NewsKindMapper kindMapper;

    private AdminNewsMapper adminNewsMapper;

    private BizConfigProperties bizConfigProperties;

    private NewsElasticIntegrationService newsElasticIntegrationService;

    private NewsSyncService newsSyncService;

    private RedisStringAdapter redisStringAdapter;

    private NewsIntegrationService newsIntegrationService;

    private SpiderManageService spiderManageService;

    private NewsConverter newsConverter;

    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    private ForumPostService forumPostService;

    private MixRecommendPoolService mixRecommendPoolService;

    private EditorMessageMapper editorMessageMapper;

    private LocationService locationService;

    private AdminNewsPageConverter adminNewsPageConverter;

    @Autowired(required = false)
    public AdminNewsServiceImpl(AdminNewsMapper adminNewsMapper,
                                BizConfigProperties bizConfigProperties,
                                NewsElasticIntegrationService newsElasticIntegrationService,
                                NewsSeqComponent newsSeqComponent,
                                NewsKindMapper kindMapper,
                                NewsSyncService newsSyncService,
                                RedisStringAdapter redisStringAdapter,
                                SpiderManageService spiderManageService,
                                NewsIntegrationService newsIntegrationService,
                                MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                MixRecommendPoolService mixRecommendPoolService,
                                ForumPostService forumPostService,
                                NewsConverter newsConverter,
                                EditorMessageMapper editorMessageMapper,
                                LocationService locationService,
                                AdminNewsPageConverter adminNewsPageConverter) {
        this.adminNewsMapper = adminNewsMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.newsElasticIntegrationService = newsElasticIntegrationService;
        this.newsSeqComponent = newsSeqComponent;
        this.kindMapper = kindMapper;
        this.newsSyncService = newsSyncService;
        this.redisStringAdapter = redisStringAdapter;
        this.newsIntegrationService = newsIntegrationService;
        this.spiderManageService = spiderManageService;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.mixRecommendPoolService = mixRecommendPoolService;
        this.forumPostService = forumPostService;
        this.newsConverter = newsConverter;
        this.editorMessageMapper = editorMessageMapper;
        this.locationService = locationService;
        this.adminNewsPageConverter = adminNewsPageConverter;
    }

    @Override
    public PageWarper<NewsOverView> queryNews(NewsParam newsParam) {
        logger.info("分页查询->NewsParam:{}", JSON.toJSON(newsParam));
        AdminNewsPageParam adminNewsPageParam = adminNewsPageConverter.convert(newsParam);
        //从es中查询新闻
        NewsDTO pageWarper = newsElasticIntegrationService.listNews(adminNewsPageParam);

        List<NewsOverView> newsDtoList = new ArrayList<>();
        if (null != pageWarper && CollectionUtils.isNotEmpty(pageWarper.getNewsList())) {
            newsDtoList = pageWarper.getNewsList().parallelStream().map(this::fillNewsOverView).collect(Collectors.toList());
        }
        com.github.pagehelper.Page page = new Page(newsParam.getPageNum(), newsParam.getPageSize());
        page.setTotal(pageWarper.getTotal()!=null?pageWarper.getTotal():0);
        page.addAll(newsDtoList);
        return new PageWarper<>(page);
    }

    /**
     * 补全新闻列表所需字段
     * @param news
     * @return
     */
    private NewsOverView fillNewsOverView(NewsWarperDTO news) {
        NewsOverView newsDto = new NewsOverView();

        //补全地区信息
        if (null != news.getAreaDetail()) {
            newsDto.setAreaDetail(locationService.getAreaDetail(news.getAreaDetail()));
        }

        //新闻详情地址
        newsDto.setLinkUrl(getH5ServerHost(news.getId(), news.getType()));

        //新闻展示标签
        newsDto.setShowLevelDetail(this.fillingShowLevelDetail(
                news.getTop(),
                news.getHot(),
                news.getKindTop(),
                news.getAreaDetail(),
                null));

        //转换实体
        this.convertNews(news, newsDto);
        return newsDto;
    }

    /**
     * 得到新闻详情的H5链接
     * @param id
     * @param type
     * @return
     */
    private String getH5ServerHost(Long id, Byte type) {
        String h5ServerHost = bizConfigProperties.getH5ServerHost();
        if (type == 1 || type == 3) {
            return h5ServerHost + "/newsDetail.html?newsId=" + id + "&userId=" + "&type="
                    + type;
        }
        return null;
    }

    /**
     * 填充新闻的标签
     * @param top
     * @param hot
     * @param kindTop
     * @param areaDetailArray
     * @param areaDetailStr
     * @return
     */
    private String fillingShowLevelDetail(Byte top, Byte hot, Byte kindTop, String[] areaDetailArray, String areaDetailStr) {
        List<String> showLevelDetail = new ArrayList();
        // 魔法值定义
        if (top != null && top == 2) {
            showLevelDetail.add("0");
        }
        if (hot != null && hot == 2) {
            showLevelDetail.add("1");
        }
        if (kindTop != null && kindTop == 2) {
            showLevelDetail.add("2");
        }
        if (hot != null && hot == 3) {
            showLevelDetail.add("3");
        }
        if (StringUtils.isNotEmpty(areaDetailStr) && ArrayUtils.isNotEmpty(areaDetailArray)) {
            showLevelDetail.add("4");
        }
        if (CollectionUtils.isEmpty(showLevelDetail)) {
            showLevelDetail.add("99");
        }
        return StringUtils.join(showLevelDetail, ",");
    }

    /**
     * 新闻转换，转换为新闻列表实体
     * @param news
     * @param newsDto
     */
    private void convertNews(com.bxm.localnews.admin.dto.NewsWarperDTO news, NewsOverView newsDto) {
        newsDto.setAddTime(news.getAddTime());
        newsDto.setId(news.getId());
        newsDto.setIssueTime(news.getIssueTime());
        newsDto.setKindId(news.getKindId());
        newsDto.setPublishTime(news.getPublishTime());
        newsDto.setStatus(news.getStatus());
        newsDto.setTitle(news.getTitle());
        newsDto.setType(news.getType());
        newsDto.setReviewStatus(news.getReviewStatus());
        newsDto.setAuthor(news.getAuthor());
        newsDto.setIsRecommend(news.getIsRecommend());
        newsDto.setDeliveryType(news.getDeliveryType());
    }

    @Override
    public int updateByPrimaryKeySelective(News news) {
        return this.adminNewsMapper.updateByPrimaryKeySelective(news);
    }

    @Override
    public int updateNewsStatusByIds(String[] ids, Byte status) {
        return this.adminNewsMapper.updateNewsStatusByIds(ids, status);
    }

    @Override
    public News selectByPrimaryKey(Long id) {
        logger.debug("新闻详情es开始拉取 ");
        NewsDetailDTO newsDetailDTO = newsElasticIntegrationService.getNewsFromES(id);
        if (null == newsDetailDTO) {
            return null;
        }

        News news = new News();
        BeanUtils.copyProperties(newsDetailDTO, news);
        if (StringUtils.isNotBlank(newsDetailDTO.getAreaDetail())) {
            news.setAreaDetail((locationService.getAreaDetail(newsDetailDTO.getAreaDetail().split(","))));
        }

        //设置新闻标签
        news.setShowLevelDetail(this.fillingShowLevelDetail(
                news.getTop(),
                news.getHot(),
                news.getKindTop(),
                null,
                news.getAreaDetail()));

        news.setLinkUrl(getH5ServerHost(news.getId(), news.getType()));

        //设置编辑寄语
        if (news.getEditorMessageId() != null) {
            EditorMessage editorMessage = editorMessageMapper.selectByPrimaryKey(news.getEditorMessageId());
            if (editorMessage != null) {
                news.setEditorMessageName(editorMessage.getTemplateName());
            }
        }

        //如果没有封面，则用内容图做封面
        if (StringUtils.isEmpty(news.getCoverList())) {
            news.setCoverList(news.getImgUrl());
        }

        //如果有视频，则将视频图作为视频封面图
        if (StringUtils.isNotBlank(news.getVideoStr())) {
            List<PostImg> postImgList = JSONArray.parseArray(news.getVideoStr(), PostImg.class);
            if (CollectionUtils.isNotEmpty(postImgList)) {
                List<String> videoList = postImgList.stream()
                        .filter(e -> org.apache.commons.lang3.StringUtils.isNotBlank(e.getType()) && "VIDEO".equals(e.getType()))
                        .map(PostImg::getImgUrl).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(videoList)) {
                    news.setVideoPosterList(JSONObject.toJSONString(videoList));
                }
            }
        }

        logger.debug("新闻详情拉取完成：{}", newsDetailDTO);
        return news;
    }

    @Override
    public Json addNews(NewsAddParam newsParam) {
        News news = new News();
        news.setId(getNewsId(newsParam));
        news.setTitle(newsParam.getTitle());
        news.setAddTime(Calendar.getInstance().getTime());
        news.setIssueTime(newsParam.getIssueTime());
        news.setPublishTime(newsParam.getPublishTime());
        news.setStatus(newsParam.getStatus() == null ? NewsStatusEnum.UNPUBLISHED.getCode() : newsParam.getStatus());
        news.setDeliveryType(newsParam.getDeliveryType());
        //我也不知道为什么要设null字符串
        news.setAddress("null");
        //新闻默认为1，以前还有视频和组图，现在没有了
        news.setType((byte) 1);
        news.setAuthor(newsParam.getAuthor());
        news.setKindId(newsParam.getKindId());
        news.setKindName(newsConverter.getKindName(Long.valueOf(newsParam.getKindId())));
        news.setReviewStatus(newsParam.getReviewStatus() == null ? NewsStatusEnum.AUDITED.getCode() : newsParam.getReviewStatus());
        news.setIsBootDownload(newsParam.getIsBootDownload());
        news.setEditorMessage(newsParam.getEditorMessage());
        news.setEditorMessageId(newsParam.getEditorMessageId());
        news.setEnablePlaceholder(newsParam.getEnablePlaceholder());
        news.setContent(newsParam.getContent());
        news.setCoverSelect(newsParam.getCoverSelect());
        //提取内容中的视频和图片
        this.analyzeContent(news);

        //取得封面
        if (StringUtils.isNotBlank(newsParam.getCoverList())) {
            news.setCoverList(JSON.toJSONString(newsParam.getCoverList().split(",")));
        }

        //取得热门，以及热门过期时间
        news.setHot(newsParam.getHot());
        if (newsParam.getHot() == 2) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newsParam.getIssueTime());
            calendar.add(Calendar.HOUR, 24);
            news.setHotExpireTime(calendar.getTime());
        }
        //频道是否置顶
        news.setKindTop((byte) 1);

        //推荐是否置顶
        news.setTop(newsParam.getTop());
        if (newsParam.getTop() == 2) {
            news.setTopExpireTime(newsParam.getTopExpireTime());
        }

        // 投放为区域型
        fillTheAreaDetail(news,newsParam.getDeliveryType(),newsParam.getAreaCodes());

        this.newsSyncService.save(news);

        // 创建发布新闻job并清除首页置顶新闻列表缓存
        this.createPublishNewsTaskJob(news, newsParam.getAreaCodes());

        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(newsParam.getAreaCodes(), null);

        return ResultUtil.genSuccessResult();
    }

    /**
     *
     * 填充新闻中的地区以及是否全国投放标识
     * @param news 新闻
     * @param deliveryType 投放标识
     * @param areaDetail 地区信息
     * @return
     */
    private Message fillTheAreaDetail(News news, Integer deliveryType, String areaDetail) {
        // 投放为区域型
        if (MarketingActivitiesDeliveryTypeEnum.AREA.getCode().equals(deliveryType)) {
            if (StringUtils.isNotBlank(areaDetail)) {
                news.setAreaDetail(areaDetail);
                news.setDeliveryType(MarketingActivitiesDeliveryTypeEnum.AREA.getCode());
            } else {
                return Message.build(false, "投放区域入参错误");
            }
        } else {
            news.setDeliveryType(MarketingActivitiesDeliveryTypeEnum.NATIONWIDE.getCode());
            //若设为全国投放后有不想投放的区域，则赋值
            news.setAreaDetail(areaDetail);
        }
        return Message.build(true);
    }

    /**
     * 分析新闻内容中的视频和图片
     * @param news
     */
    private void analyzeContent(News news){
        //提取内容中的视频和图片
        List<PostImg> videoList = new ArrayList<>();
        List<String> imgList = new ArrayList<>();
        String content =forumPostService.extractVideoAndImgFromContent(news.getContent(),news.getVideoPosterList(),videoList, imgList);

        news.setContent(content);
        if (CollectionUtils.isNotEmpty(videoList)) {
            news.setVideoList(JSONObject.toJSONString(videoList));
        }

        if (CollectionUtils.isNotEmpty(imgList)) {
            news.setImgUrl(JSONObject.toJSONString(imgList));
        } else {
            news.setImgUrl("");
        }
    }

    /**
     * 得到新闻id
     * @param newsAddParam
     * @return
     */
    private Long getNewsId(NewsAddParam newsAddParam) {
        Long id;
        if (null != newsAddParam.getId()) {
            id = newsAddParam.getId();
        } else {
            id = newsSeqComponent.getNewsId();
        }
        return id;
    }

    @Override
    public Json updateNews(NewsUpdateParam newsUpdateParam) {
        News oldNews = adminNewsMapper.selectByPrimaryKey(newsUpdateParam.getId());
        if (oldNews == null) {
            return ResultUtil.genFailedResult("新闻不存在");
        }
        if (logger.isDebugEnabled()){
            logger.debug("更新新闻参数:[{}],原始新闻数据:[{}]",JSONObject.toJSONString(newsUpdateParam),JSONObject.toJSONString(oldNews));
        }
        News news = new News();
        news.setId(oldNews.getId());
        news.setTitle(newsUpdateParam.getTitle());
        //对已经审核通过或者上线的新闻不修改其状态
        if (NewsStatusEnum.AUDITED.getCode().equals(oldNews.getReviewStatus())) {
            logger.debug("新闻审核时发现已经审核通过了");
            news.setReviewStatus(oldNews.getReviewStatus());
        } else {
            news.setReviewStatus(newsUpdateParam.getReviewStatus());
        }

        if (NewsStatusEnum.ENABLE.getCode().equals(oldNews.getStatus())) {
            logger.debug("新闻修改状态时发现已经上线了");
            news.setStatus(oldNews.getStatus());
        } else {
            news.setStatus(newsUpdateParam.getStatus());
        }

        news.setAuthor(newsUpdateParam.getAuthor());
        news.setKindId(newsUpdateParam.getKindId());
        news.setKindName(newsConverter.getKindName(Long.valueOf(newsUpdateParam.getKindId())));
        news.setIsBootDownload(newsUpdateParam.getIsBootDownload());
        news.setIssueTime(newsUpdateParam.getIssueTime());
        news.setPublishTime(newsUpdateParam.getPublishTime());
        news.setEditorMessageId(newsUpdateParam.getEditorMessageId());
        news.setEnablePlaceholder(newsUpdateParam.getEnablePlaceholder());
        news.setContent(newsUpdateParam.getContent());
        news.setVideoPosterList(newsUpdateParam.getVideoPosterList());
        news.setCoverSelect(newsUpdateParam.getCoverSelect());
        //提取内容中的视频和图片
        this.analyzeContent(news);
        news.setCoverList(StringUtils.isNotBlank(newsUpdateParam.getCoverList()) ? JSON.toJSONString(newsUpdateParam.getCoverList().split(",")) : null);
        news.setEditorMessage(StringUtils.isNotBlank(newsUpdateParam.getEditorMessage()) ? newsUpdateParam.getEditorMessage() : null);

        // 投放为区域型
        fillTheAreaDetail(news,newsUpdateParam.getDeliveryType(),newsUpdateParam.getAreaCodes());

        //置顶与频道置顶
        news.setTop(newsUpdateParam.getTop());
        news.setKindTop(newsUpdateParam.getKindTop());
        if (newsUpdateParam.getTop() == 2) {
            if (newsUpdateParam.getReviewStatus() != 2 || newsUpdateParam.getStatus() != 1) {
                return ResultUtil.genFailedResult("亲，新闻审核状态异常或者新闻状态异常呢！");
            }
            news.setTopExpireTime(newsUpdateParam.getTopExpireTime());
        }

        //热门
        news.setHot(newsUpdateParam.getHot());
        if (newsUpdateParam.getHot() == 2) {
            if (oldNews.getHotExpireTime() == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(newsUpdateParam.getIssueTime());
                calendar.add(Calendar.HOUR, 24);
                news.setHotExpireTime(calendar.getTime());
            }
        }

        // 创建发布新闻job ,在更新爬过来的新闻时，不需要定时发布新闻
        if (oldNews.getStatus().equals(NewsStatusEnum.UNPUBLISHED.getCode())) {
            if (oldNews.getPublishTime() != null) {
                this.createPublishNewsTaskJob(oldNews, newsUpdateParam.getAreaCodes());
            }
        }

        //如果是异常状态就或者是置顶，就从推荐库中去除，并将标志设为0
        if ((news.getStatus() != -1 && news.getStatus() != 1) || news.getTop() == 2) {
            news.setIsRecommend((byte) 0);
        }

        ResponseEntity save = this.newsSyncService.save(news);
        if (save.getStatusCode() == HttpStatus.OK){
            updateRecommendWhenChanged(news);
        }
        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(newsUpdateParam.getAreaCodes(), oldNews.getAreaDetail());
        return ResultUtil.genSuccessResult();
    }

    /**
     * 变更推荐库内容
     * @param param
     */
    public void updateRecommendWhenChanged(News param) {
        //更新推荐池内容
        MixedRecommendPool result = mixedRecommendPoolMapper.selectByPrimaryKey(param.getId());
        if (Objects.nonNull(result)) {
            if ((!param.getStatus().equals(NewsStatusEnum.UNPUBLISHED.getCode())
                    && !param.getStatus().equals(NewsStatusEnum.ENABLE.getCode()))
                    || 2 == param.getTop()) {
                mixedRecommendPoolMapper.deleteByPrimaryKey(result.getId());
            } else {
                MixedRecommendPool mixedRecommendPool = MixedRecommendPool.builder()
                        .id(param.getId())
                        .title(param.getTitle())
                        .publishTime(param.getPublishTime())
                        .issueTime(param.getIssueTime())
                        .author(param.getAuthor())
                        .areaDetail(param.getAreaDetail())
                        .weight(result.getWeight())
                        .auto(result.getAuto())
                        .recommendTime(result.getRecommendTime())
                        .optimizationNotice(result.getOptimizationNotice())
                        .deliveryType(param.getDeliveryType()).build();
                if (1 == param.getDeliveryType()) {
                    mixedRecommendPool.setOrigin(MixRecommendTypeEnum.MIX_LOCAL_NEWS.getCode());
                } else {
                    mixedRecommendPool.setOrigin(MixRecommendTypeEnum.MIX_NATION_NEWS.getCode());
                }
                mixRecommendPoolService.updateMixRecommend(mixedRecommendPool);
            }
        } else {
            //审核通过并状态为上线
            if (param.getReviewStatus().equals(NewsStatusEnum.AUDITED.getCode()) && param.getStatus().equals(NewsStatusEnum.ENABLE.getCode())) {
                mixRecommendPoolService.addNewsToRecommendPoolAuto(param);
            }
        }
    }

    @Override
    public List<NewsKind> getAllKind() {
        return kindMapper.selectAllKinds();
    }

    @Override
    public Json settingLevel(ShowLevelEnum showLevelEnum, Long id) {
        News news = adminNewsMapper.selectByPrimaryKey(id);
        if (news == null) {
            return ResultUtil.genFailedResult("新闻不存在");
        }
        News param = new News();
        if (StringUtils.isNotBlank(news.getShowLevelDetail())) {
            String[] levels = StringUtils.split(news.getShowLevelDetail(), ",");
            List<String> levelList = new ArrayList<>(Arrays.asList(levels));
            if (!levelList.contains(showLevelEnum.getCode() + "")) {
                levelList.add(showLevelEnum.getCode() + "");
            }
            Collections.sort(levelList);
            param.setId(id);
            param.setShowLevel(Integer.parseInt(levelList.get(0)));
            param.setShowLevelDetail(StringUtils.join(levelList, ","));
            adminNewsMapper.updateByPrimaryKeySelective(param);
        } else {
            param.setId(id);
            param.setShowLevel(showLevelEnum.getCode());
            param.setShowLevelDetail(showLevelEnum.getCode() + "");
            adminNewsMapper.updateByPrimaryKeySelective(param);
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public ContentDTO getSpiderContent(CrawlingParam param) {
        ResponseEntity<ContentDTO> contentDTOResponseEntity = spiderManageService.pageDownload(param);
        return contentDTOResponseEntity.getBody();
    }

    @Override
    public Message addAccount(AccountAddParam accountAddParam) {
        return spiderManageService.addAccountByName(accountAddParam).getBody();
    }

    @Override
    public void review(Long id, Byte review) {
        News news = adminNewsMapper.selectByPrimaryKey(id);
        if (null!=news) {
            News newsParam = new News();
            newsParam.setId(id);
            newsParam.setReviewStatus(review);
            ResponseEntity save = newsSyncService.updateStatus(newsParam);
            if (review.equals(NewsStatusEnum.AUDITED.getCode()) && save.getStatusCode() == HttpStatus.OK){
                mixRecommendPoolService.addNewsToRecommendPoolAuto(news);
            }
        }
    }

    @Override
    public void batchReview(String ids, Byte review) {
        String[] idArray = ids.split(",");
        if (idArray.length > 0) {
            for (String idStr : idArray) {
                News news = adminNewsMapper.selectByPrimaryKey(Long.valueOf(idStr));
                News newsParam = new News();
                newsParam.setId(Long.valueOf(idStr));
                newsParam.setReviewStatus(review);
                ResponseEntity save = newsSyncService.updateStatus(newsParam);
                if (review.equals(NewsStatusEnum.AUDITED.getCode()) && save.getStatusCode() == HttpStatus.OK) {
                    mixRecommendPoolService.addNewsToRecommendPoolAuto(news);
                }
            }
        }
    }

    @Override
    public Long getCreateId() {
        return newsSeqComponent.getNewsId();
    }

    /**
     * 清理置顶新闻缓存基础方法
     * @param areaCodeStr
     */
    private void cleanRedisCacheOfTopNews(String areaCodeStr) {
        if (StringUtils.isNotEmpty(areaCodeStr)) {
            String[] areaCodes = areaCodeStr.split(",");
            for (String areaCode : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(areaCode);
                redisStringAdapter.remove(keyGenerator);
            }
        }
    }

    /**
     * 清理置顶新闻缓存（修改更新新闻时）
     * @param newAreaCodeStr
     * @param oldAreaCodeStr
     */
    private void clearRedisCacheOfTopNewsList(String newAreaCodeStr, String oldAreaCodeStr) {
        // 删除更新后的地区置顶新闻缓存
        cleanRedisCacheOfTopNews(newAreaCodeStr);
        // 删除更新前的地区置顶新闻缓存
        cleanRedisCacheOfTopNews(oldAreaCodeStr);
        // 清除全国性置顶新闻缓存
        redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
    }

    /**
     * 清理置顶新闻缓存（删除新闻时）
     * @param areaCodeStr
     */
    private void clearRedisCacheOfTopNewsList(String areaCodeStr) {
        // 删除地区置顶新闻缓存
        cleanRedisCacheOfTopNews(areaCodeStr);
        // 清除全国性置顶新闻缓存
        redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
    }

    /**
     * 新闻定时任务发布
     * @param news
     * @param areaCodes
     */
    private void createPublishNewsTaskJob(News news, String areaCodes) {
        PublishNewsBuildParam param = new PublishNewsBuildParam();
        param.setAreaCodes(areaCodes);
        param.setNewsId(news.getId());
        param.setStartTime(news.getPublishTime());
        logger.debug("创建发布新闻:{}", JSON.toJSONString(param));
        newsIntegrationService.addPublish(param);
    }

    @Override
    public int deleteNewsById(Long id) {
        News oldNews = adminNewsMapper.selectByPrimaryKey(id);
        News newsParam = new News();
        newsParam.setId(id);
        newsParam.setIsRecommend((byte) 0);
        newsParam.setStatus(NewsStatusEnum.DELETE.getCode());
        ResponseEntity update = newsSyncService.updateStatus(newsParam);

        int result = 0;
        if (update.getStatusCode() == HttpStatus.OK) {
            //删除新闻时将推荐库的内容删除
            result = mixedRecommendPoolMapper.deleteByPrimaryKey(id);
        }


        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(oldNews.getAreaDetail());
        return result;
    }

    @Override
    public PageWarper<AccountQueryDto> listWechatAccount(AccountQueryParam accountQueryParam) {
        return spiderManageService.queryAccountByName(accountQueryParam.getAccount(),
                accountQueryParam.getRegionCode(),
                accountQueryParam.getPageNum(),
                accountQueryParam.getPageSize())
                .getBody();
    }

    @Override
    public void deleteWechatAccountById(Long id) {
        spiderManageService.deleteById(id).getBody();
    }
}
