package com.bxm.localnews.admin.service.news.impl;


import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.news.domain.CommonTagMapper;
import com.bxm.localnews.admin.service.news.CommonTagService;
import com.bxm.localnews.admin.vo.CommonTag;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonTagServiceImpl implements CommonTagService {

    private final CommonTagMapper commonTagMapper;

    private Logger logger = LoggerFactory.getLogger(CommonTagServiceImpl.class);

    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public CommonTagServiceImpl(CommonTagMapper commonTagMapper,
                                RedisHashMapAdapter redisHashMapAdapter) {
        this.commonTagMapper = commonTagMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public long saveAndGetTag(String tagName) {
        logger.info("获取tagName:{}", tagName);
        long hashCode = tagName.hashCode();

        long collectionIndex = hashCode % 10;
        KeyGenerator tagKey = RedisConfig.SPIDER_TAG_INDEX.copy().appendKey(collectionIndex);

        Long id = redisHashMapAdapter.get(tagKey, tagName, Long.class);
        if (null == id) {
            //id使用数据库自增 需用作坐标计算 不可以无序切过大
            CommonTag tag = commonTagMapper.findByName(tagName);
            if (tag == null) {
                tag = new CommonTag();
                tag.setName(tagName);
                commonTagMapper.insert(tag);
            }
            logger.info("tag.getId()={}", tag.getId());
            redisHashMapAdapter.put(tagKey, tagName, tag.getId());
            return tag.getId();
        }

        return id;
    }
}
