package com.bxm.localnews.admin.service.news.impl;

import com.bxm.localnews.admin.constant.NewsStatusEnum;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.service.news.AdminNewsService;
import com.bxm.localnews.admin.service.news.NewsService;
import com.bxm.localnews.admin.vo.GlobalNewsBlackEntity;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.news.domain.AdminNewsBlackMapper;
import com.bxm.localnews.news.domain.AdminNewsMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;

@Service
public class NewsServiceImpl implements NewsService {

    private RedisListAdapter redisListAdapter;

    private AdminNewsMapper adminNewsMapper;

    private AdminNewsBlackMapper adminNewsBlackMapper;

    private RedisStringAdapter redisStringAdapter;

    private NewsSyncService newsSyncService;

    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    @Autowired
    public NewsServiceImpl(AdminNewsMapper adminNewsMapper, AdminNewsBlackMapper adminNewsBlackMapper,
                           RedisListAdapter redisListAdapter, RedisStringAdapter redisStringAdapter,
                           NewsSyncService newsSyncService, MixedRecommendPoolMapper mixedRecommendPoolMapper) {
        this.adminNewsMapper = adminNewsMapper;
        this.adminNewsBlackMapper = adminNewsBlackMapper;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.newsSyncService = newsSyncService;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void addNewsBlack(Long newsId, String remark) {
        GlobalNewsBlackEntity entity = new GlobalNewsBlackEntity();
        entity.setCreateTime(Calendar.getInstance().getTime());
        entity.setRemark(remark);
        // 无意义缺省值
        entity.setType(0);
        entity.setNewsId(newsId);
        adminNewsBlackMapper.insert(entity);

        News news = adminNewsMapper.selectByPrimaryKey(newsId);
        News newsParam = new News();
        newsParam.setId(newsId);
        newsParam.setStatus(NewsStatusEnum.DISABLE.getCode());
        newsParam.setIsRecommend((byte) 0);
        ResponseEntity update =  newsSyncService.updateStatus(newsParam);
        if (update.getStatusCode() == HttpStatus.OK){
            //下线新闻时将推荐库的内容删除
            mixedRecommendPoolMapper.deleteByPrimaryKey(newsId);
        }

        redisListAdapter.leftTrim(RedisConfig.NEWS_BLACK.copy(), 1, 0);
        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(news.getAreaDetail(),null);
    }

    @Transactional
    @Override
    public void delNewsBlack(Long newsId) {
        adminNewsBlackMapper.deleteByNewsId(newsId);

        News news = adminNewsMapper.selectByPrimaryKey(newsId);
        News newsParam = new News();
        newsParam.setId(newsId);
        newsParam.setStatus(NewsStatusEnum.ENABLE.getCode());
        newsSyncService.updateStatus(newsParam);

        redisListAdapter.leftTrim(RedisConfig.NEWS_BLACK.copy(), 1, 0);

        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(news.getAreaDetail(),null);
    }

    /**
     * @param newAreaCodeStr
     * @param oldAreaCodeStr
     * @Description 方法描述：清除首页置顶新闻列表缓存
     * @author leon 2019年1月15日 下午5:10:00
     * @CopyRight 杭州微财网络科技有限公司
     */
    private void clearRedisCacheOfTopNewsList(String newAreaCodeStr, String oldAreaCodeStr) {
        // 删除更新后的地区置顶新闻缓存
        if (StringUtils.isNotEmpty(newAreaCodeStr)) {
            String[] areaCodes = newAreaCodeStr.split(",");
            for (String areaCode : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(areaCode);
                redisStringAdapter.remove(keyGenerator);
            }
        }
        // 删除更新前的地区置顶新闻缓存
        if (StringUtils.isNotEmpty(oldAreaCodeStr)) {
            String[] areaCodes = oldAreaCodeStr.split(",");
            for (String obj : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(obj);
                redisStringAdapter.remove(keyGenerator);
            }
        }
        // 清除全国性置顶新闻缓存
        redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
    }
}
