package com.bxm.localnews.admin.service.recommend;

import com.bxm.localnews.admin.dto.MixRecommandDTO;
import com.bxm.localnews.admin.param.MixPoolParam;
import com.bxm.localnews.admin.param.MixRecommandParam;
import com.bxm.localnews.admin.param.MixRecommendTopParam;
import com.bxm.localnews.admin.vo.ForumPost;
import com.bxm.localnews.admin.vo.MixedRecommendPool;
import com.bxm.localnews.admin.vo.News;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.Date;

public interface MixRecommendPoolService {
    /**
     * 推荐池分页查询
     * @param mixRecommandParam
     * @return
     */
    PageWarper<MixRecommandDTO> listPagination(MixRecommandParam mixRecommandParam);

    /**
     * 取消推荐
     * @param mixPoolParam
     * @return
     */
    int doCancelMixRecommend(MixPoolParam mixPoolParam);

    /**
     * 修改推荐池权重
     * @param mixPoolParam
     * @param weight
     * @return
     */
    int updateMixRecommendWeight(MixPoolParam mixPoolParam, Integer weight);

    /**
     * 修改推荐池时间
     * @param id
     * @param recommendTime
     * @return
     */
    int doUpdateRecommendTimeById(Long id, Date recommendTime);

    /**
     * 将新闻和帖子添加到推荐池
     * @param mixPoolParam
     * @return
     */
    Message addMixRecommendPool(MixPoolParam mixPoolParam);

    /**
     * 更改新闻或者帖子内容时同步修改推荐池中的内容
     * @param mixedRecommendPool  需要修改的字段
     * @return
     */
    int updateMixRecommend(MixedRecommendPool mixedRecommendPool);

    /**
     * 推荐池置顶
     * @param mixPoolParam
     * @return
     */
    int addTop(MixRecommendTopParam mixPoolParam);

    /**
     * 本地新闻通过审核时自动加入混合推荐池
     * @param news
     * @return
     */
    int addNewsToRecommendPoolAuto(News news);

    /**
     * 帖子被加精时自动加入混合推荐池
     * @param forumPost
     * @return
     */
    int addPostToRecommendPoolAuto(ForumPost forumPost);

}
