package com.bxm.localnews.admin.service.security;

import com.bxm.localnews.admin.dto.UserInfoDTO;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.vo.User;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/12/18.
 */
public interface AdminUserBaseInfoService {

    /**
     * 获取用户信息
     * @param param
     * @return 分页结果
     */
    PageWarper<UserInfoDTO> queryUserInfoDTO(UserInfoParam param);

    /**
     * 查询用户信息
     * @param userId
     * @return
     */
    User selectByUserId(Long userId);

    /**
     * 设置和取消用户黑名单
     * @param map
     * @return
     */
    boolean updateUserBlack(Map<String, Object> map);

    /**
     * 删除用户
     * @param userId
     * @return
     */
    Boolean deleteUser(Long userId);

    /**
     * 获取虚拟用户列表
     * @return
     */
    List<UserInfoDTO> getVirtualUserList();

    /**
     *
     * @param nickname
     * @param headImg
     * @return
     */
//    Boolean addVirtualUser(String nickname, String headImg);
}
