package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.domain.AdminRoleMapper;
import com.bxm.localnews.admin.dto.AdminRoleDTO;
import com.bxm.localnews.admin.param.RoleParam;
import com.bxm.localnews.admin.service.security.AdminRoleService;
import com.bxm.localnews.admin.vo.security.AdminRole;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.vo.PageWarper;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhaoyadong 2018/10/16 11:02
 * @desc
 */
@Service
public class AdminRoleServiceImpl implements AdminRoleService {

    private AdminRoleMapper adminRoleMapper;

    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public AdminRoleServiceImpl(AdminRoleMapper adminRoleMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.adminRoleMapper = adminRoleMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public PageWarper<AdminRoleDTO> selectAll(RoleParam roleParam) {
        return new PageWarper<>(this.adminRoleMapper.selectAll(roleParam));
    }

    @Override
    public AdminRole selectByRoleCode(String roleCode) {
        return this.adminRoleMapper.selectByRoleCode(roleCode);
    }

    @Override
    public int insertSelective(AdminRole adminRole) {
        return this.adminRoleMapper.insertSelective(adminRole);
    }

    @Override
    public int updateByPrimaryKeySelective(AdminRole adminRole) {
        return this.adminRoleMapper.updateByPrimaryKeySelective(adminRole);
    }

    @Override
    public int deleteByPrimaryKey(Integer roleId) {
        return this.adminRoleMapper.deleteByPrimaryKey(roleId);
    }

    @Override
    public AdminRole selectByPrimaryKey(Integer roleId) {
        return this.adminRoleMapper.selectByPrimaryKey(roleId);
    }

    @Override
    public List<AdminRole> selectByUserId(Long id) {
        TypeReference<List<AdminRole>> typeReference = new TypeReference<List<AdminRole>>() {

        };
        List<AdminRole> permissions = redisHashMapAdapter.get(getRoleKey(), id.toString(), typeReference);
        if (CollectionUtils.isEmpty(permissions)) {
            permissions = adminRoleMapper.selectByUserId(id);
            if (CollectionUtils.isNotEmpty(permissions)) {
                redisHashMapAdapter.put(getRoleKey(), id.toString(), permissions);
            }
        }
        return permissions;
    }

    @Override
    public Collection<? extends GrantedAuthority> getUserAuthorities(Long userId) {
        List<AdminRole> permissions = this.selectByUserId(userId);
        Collection<? extends GrantedAuthority> authorities = permissions.stream()
                .map(permission -> new SimpleGrantedAuthority("ROLE_" + permission.getRoleCode()))
                .collect(Collectors.toList());

        return authorities;
    }

    @Override
    public KeyGenerator getRoleKey() {
        return DefaultKeyGenerator.build("admin", "role", "user");
    }
}
