package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.EquipmentInfoMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.domain.auth.UserRoleMapper;
import com.bxm.localnews.admin.dto.EquipmentDTO;
import com.bxm.localnews.admin.dto.UserInfoDTO;
import com.bxm.localnews.admin.integration.BizIntegrationService;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.UserLoginHistory;
import com.bxm.localnews.admin.vo.auth.UserRoleBean;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by Administrator on 2017/12/19.
 */

@Service
public class AdminUserBaseInfoServiceImpl extends BaseService implements AdminUserBaseInfoService {

    /**
     * 日志对象
     */
    private static final Logger LOG = LoggerFactory.getLogger(AdminUserBaseInfoServiceImpl.class);

    @Resource
    private UserMapper userBaseInfoMapper;

    @Resource
    private EquipmentInfoMapper equipmentInfoMapper;

    @Resource
    private BizIntegrationService bizIntegrationService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private UserRoleMapper userRoleMapper;

    @Override
    public PageWarper<UserInfoDTO> queryUserInfoDTO(UserInfoParam param) {
        PageWarper<UserInfoDTO> pageWarper = new PageWarper<>(this.userBaseInfoMapper.queryUserInfoList(param));

        if (!CollectionUtils.isEmpty(pageWarper.getList())) {
            List<Long> userIdList = Lists.newArrayList();

            pageWarper.getList().forEach(item -> userIdList.add(Long.valueOf(item.getUserId())));

            List<UserRoleBean> userRoles = userRoleMapper.queryUserRoles(userIdList);
            if (userRoles.size() > 0) {
                pageWarper.getList().forEach(user -> {
                    List<String> userRoleCodes = userRoles.stream().filter(userRole ->
                            userRole.getUserId().equals(Long.valueOf(user.getUserId())))
                            .map(UserRoleBean::getRoleCode).collect(Collectors.toList());

                    user.setRoles(userRoleCodes);
                });
            }
        }

        return pageWarper;
    }

    @Override
    public User selectByUserId(Long userId) {
        return this.userBaseInfoMapper.selectByUserId(userId);
    }

    @Override
    public boolean updateUserBlack(Map<String, Object> map) {
        return this.userBaseInfoMapper.updateUserBlack(map);
    }

    @Override
    public Boolean deleteUser(Long userId) {
        Long id = nextId();
        User user = selectByUserId(userId);

        if (null == user) {
            LOG.error("根据此userId:{}未查询到用户信息,删除用户失败", userId);
            return false;
        }
        //删除缓存
        redisHashMapAdapter.remove(RedisConfig.USER_INFO, String.valueOf(userId));

        //三步删除用户数据库 一步删除redis缓存
        String weChat = user.getWeixin() == null ? null : user.getWeixin() + id;

        //更新用户为禁用,手机号、设备号置空,微信号特殊处理。
        userBaseInfoMapper.updateUser(userId, weChat);

        //更新vip邀请查看记录的微信号特殊处理
        userBaseInfoMapper.updateVipRecord(userId, weChat);
        if (StringUtils.isNotEmpty(user.getWeixin())) {
            userBaseInfoMapper.updateVipViewRecord(user.getWeixin(), weChat);
        }

        //删除设备
        UserLoginHistory userLoginHistory = userBaseInfoMapper.selectHistoryByUserId(userId);
        if (null != userLoginHistory && StringUtils.isNoneEmpty(userLoginHistory.getEquipment())) {
            EquipmentDTO equipmentDTO = bizIntegrationService.getDevice(userLoginHistory.getEquipment());
            if (null != equipmentDTO && StringUtils.isNoneEmpty(equipmentDTO.getId())) {
                //删除用户设备的对应表
                userBaseInfoMapper.deleteUserEquipment(user.getEquipment());
                //删除设备
                equipmentInfoMapper.deleteByPrimaryKey(equipmentDTO.getId());
            }
        }

        //删除在授权登录认证表中信息
        return userBaseInfoMapper.deleteUser(userId) > 0;
    }

    @Override
    public List<UserInfoDTO> getVirtualUserList() {
        return this.userBaseInfoMapper.getVirtualUserList();
    }

//    @Override
//    public Boolean addVirtualUser(String nickname, String headImg) {
//        return this.userBaseInfoMapper.addVirtualUser(nickname, headImg) > 0;
//    }
}
