package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.domain.AdminRoleMapper;
import com.bxm.localnews.admin.domain.AdminUserMapper;
import com.bxm.localnews.admin.domain.AdminUserRoleMapper;
import com.bxm.localnews.admin.dto.AdminUserDTO;
import com.bxm.localnews.admin.param.AdminUserParam;
import com.bxm.localnews.admin.service.security.AdminRoleService;
import com.bxm.localnews.admin.service.security.AdminUserService;
import com.bxm.localnews.admin.service.security.JwtTokenService;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.admin.vo.security.AdminUserRole;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service
public class AdminUserServiceImpl implements AdminUserService {

    private RedisStringAdapter redisStringAdapter;

    private AdminUserMapper adminUserMapper;

    private JwtTokenService jwtTokenService;

    private AdminRoleService adminRoleService;

    private AdminRoleMapper adminRoleMapper;

    private RedisHashMapAdapter redisHashMapAdapter;

    private AdminUserRoleMapper adminUserRoleMapper;

    @Autowired
    public AdminUserServiceImpl(RedisStringAdapter redisStringAdapter, AdminUserMapper adminUserMapper,
                                JwtTokenService jwtTokenService, AdminRoleService adminRoleService,
                                AdminRoleMapper adminRoleMapper,RedisHashMapAdapter redisHashMapAdapter,
                                AdminUserRoleMapper adminUserRoleMapper) {
        this.redisStringAdapter = redisStringAdapter;
        this.adminUserMapper = adminUserMapper;
        this.jwtTokenService = jwtTokenService;
        this.adminRoleService = adminRoleService;
        this.adminRoleMapper = adminRoleMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.adminUserRoleMapper = adminUserRoleMapper;
    }

    @Override
    public AdminUser getCacheUser(String userName) {
        KeyGenerator key = this.getCacheKey(userName);
        AdminUser user = redisStringAdapter.get(key, AdminUser.class);
        if (null == user) {
            user = this.adminUserMapper.getByUserName(userName);
            if (null != user) {
                user.setResetTime(new Date());
                redisStringAdapter.set(key, user);
            }
        }
        return user;
    }

    @Override
    public void clearCacheUser(String userName) {
        KeyGenerator key = this.getCacheKey(userName);
        redisStringAdapter.remove(key);
    }

    @Override
    public AdminUser getUserByToken(String token) {
        if (StringUtils.isBlank(token)) {
            return new AdminUser();
        }

        String userName = jwtTokenService.getUsernameFromToken(token);
        return this.getCacheUser(userName);
    }

    @Override
    public Json modifyPassword(AdminUserDTO param) {
        String oldPassword = MD5Util.hgmd5(param.getOldPassword());
        String newPassword = MD5Util.hgmd5(param.getNewPassword());

        AdminUser oldSysUser = this.adminUserMapper.getByUserName(param.getUsername());

        if (null == oldSysUser) {
            return ResultUtil.genFailedResult("用户不存在");
        }

        if (!oldSysUser.getPassword().equals(oldPassword)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "原密码输入不正确");
        }
        if (oldSysUser.getPassword().equals(newPassword)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "新密码不能和旧密码相同");
        }

        // 密码加密
        oldSysUser.setPassword(newPassword);
        this.editUserPassWord(oldSysUser);
        this.removeCacheUser(param.getUsername());
        return ResultUtil.genSuccessMsg("密码修改成功");

    }

    @Override
    public Json modifyPasswordByAdmin(AdminUserDTO param) {
        String newPassword = MD5Util.hgmd5(param.getNewPassword());
        AdminUser oldSysUser = this.adminUserMapper.getByUserName(param.getUsername());

        if (null == oldSysUser) {
            return ResultUtil.genFailedResult("用户不存在");
        }

        oldSysUser.setPassword(newPassword);
        this.editUserPassWord(oldSysUser);
        this.removeCacheUser(param.getUsername());
        return ResultUtil.genSuccessMsg("密码修改成功");
    }

    private KeyGenerator getCacheKey(String userName) {
        return DefaultKeyGenerator.build("admin", "user", userName);
    }

    @Override
    public Message removeCacheUser(String userName) {
        return Message.build(redisStringAdapter.remove(this.getCacheKey(userName)));
    }

    @Override
    public Boolean editUserPassWord(AdminUser sysUser) {
        return this.adminUserMapper.editUserPassWord(sysUser);
    }

    @Override
    public PageWarper<AdminUserDTO> queryAdminUsers(AdminUserParam adminUserParam) {
        Preconditions.checkArgument(adminUserParam != null);

        PageHelper.startPage(adminUserParam.getPageNum(), adminUserParam.getPageSize());
        List<AdminUserDTO> list = this.adminUserMapper.queryAdminUser(adminUserParam);
        PageWarper<AdminUserDTO> pageWarper = new PageWarper<>(list);

        return pageWarper;
    }

    @Override
    public AdminUser selectByUsername(String username) {
        return this.adminUserMapper.selectByUsername(username);
    }

    @Override
    public int upsert(AdminUserDTO user) {
        String password = MD5Util.hgmd5(user.getPassword());
        user.setPassword(password);
        return this.adminUserMapper.upsert(user);
    }

    @Override
    public int updateByPrimaryKeySelective(AdminUser record) {
        String password = MD5Util.hgmd5(record.getPassword());
        record.setPassword(password);
        return this.adminUserMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public AdminUser selectById(Long id) {
        return this.adminUserMapper.selectById(id);
    }


    @Override
    public Message updateUserRole(Long userId, Integer roleId) {
        KeyGenerator roleKey = SpringContextHolder.getBean(AdminRoleService.class).getRoleKey();
        redisHashMapAdapter.remove(roleKey,userId.toString());
        Long exitRoleId = adminRoleMapper.selectRoleIdByUserId(userId);
        AdminUserRole adminUserRole = new AdminUserRole();
        adminUserRole.setUserId(userId);
        adminUserRole.setRoleId(roleId);
        if (Objects.isNull(exitRoleId)){
            adminUserRoleMapper.insertSelective(adminUserRole);
        }else{
            adminUserRoleMapper.updateRoleByUserId(adminUserRole);
        }
        return Message.build(true);
    }
}
