/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.convert.impl;

import com.bxm.localnews.admin.convert.impl.AbstractConverter;
import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.service.base.CommonDictService;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.common.constant.InfoCombineStateEnum;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class VirtualUserConverter
extends AbstractConverter<VirtualUserInfoParam, User> {
    @Autowired
    private CommonDictService commonDictService;
    @Autowired
    private LocationService locationService;

    @Override
    public User convert(VirtualUserInfoParam data) {
        User user = new User();
        user.setId(data.getId());
        user.setNickname(data.getNickname());
        user.setHeadImg(data.getHeadImg());
        user.setSex(data.getSex());
        user.setState(Byte.valueOf((byte)3));
        user.setBirthday(data.getBirthday());
        user.setAddress(data.getAddress());
        user.setJobTitle(data.getJobTitle());
        user.setCompany(data.getCompany());
        user.setJobType(data.getJobType());
        user.setJobCategory(data.getJobCategory());
        user.setHometownCode(data.getCountyCode());
        user.setPersonalProfile(data.getPersonalProfile());
        user.setUserTagIds(data.getUserTagIds());
        user.setRelationshipStatus(data.getMarry());
        user.setInfoCompleteState(this.initUserInfoCompleteStatus(user));
        this.fillUser(user);
        return user;
    }

    private Long initUserInfoCompleteStatus(User user) {
        long infoCompleteStatus = 0L;
        if (null != user.getSex() && 0 != user.getSex()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.SEX_COMPLETE.getIndex());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getNickname())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.NICKNAME_COMPLETE.getIndex());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getHeadImg())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HEAD_IMG_COMPLETE.getIndex());
        }
        if (null != user.getBirthday()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.BIRTHDAY_COMPLETE.getIndex());
        }
        if (null != user.getRelationshipStatus()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.RELATION_SHIP_COMPLETE.getIndex());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getHometownCode())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HOMETOWN_COMPLETE.getIndex());
        }
        if (null != user.getJobCategory()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.JOB_COMPLETE.getIndex());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getPersonalProfile())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PERSONAL_PROFILE_COMPLETE.getIndex());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getPhone())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PHONE_COMPLETE.getIndex());
        }
        if (!CollectionUtils.isEmpty((Collection)user.getUserTagIds())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex());
        }
        return infoCompleteStatus;
    }

    private void fillUser(User user) {
        Map<String, Location> locationMap;
        if (null != user.getJobType() && null != user.getJobCategory()) {
            user.setJobTypeName(this.commonDictService.getById(user.getJobType()).getLabel());
            user.setJobCategoryName(this.commonDictService.getById(user.getJobCategory()).getLabel());
        }
        if (null != user.getHometownCode() && MapUtils.isNotEmpty(locationMap = this.locationService.listLocation()) && null != locationMap.get(user.getHometownCode())) {
            user.setHometownName(locationMap.get(user.getHometownCode()).getFullName());
        }
    }
}

