/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.admin.common.DingtalkProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.convert.impl.SendCashConvert;
import com.bxm.localnews.admin.domain.UserAccountGrantFlowMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.CashDTO;
import com.bxm.localnews.admin.entry.UserAccountGrantFlow;
import com.bxm.localnews.admin.enums.CashEnum;
import com.bxm.localnews.admin.enums.CashFlowTypeEnum;
import com.bxm.localnews.admin.enums.UserGrantChangeTypeEnum;
import com.bxm.localnews.admin.enums.UserGrantFlowTypeEnum;
import com.bxm.localnews.admin.integration.UserAccountIntegrationService;
import com.bxm.localnews.admin.param.AccountCashParam;
import com.bxm.localnews.admin.param.BaseCashParam;
import com.bxm.localnews.admin.param.BaseFlowerParam;
import com.bxm.localnews.admin.param.CashParam;
import com.bxm.localnews.admin.param.UserAccountGrantFlowParam;
import com.bxm.localnews.admin.service.activity.GiveOutCashService;
import com.bxm.localnews.admin.service.activity.UserAccountGrantFlowService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class GiveOutCashServiceImpl
extends BaseService
implements GiveOutCashService {
    private final SendCashConvert sendCashConvert;
    private final UserMapper userMapper;
    private final UserAccountGrantFlowMapper userAccountGrantFlowMapper;
    private final MessageSender messageSender;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final HttpClientService httpClientService;
    private final DingtalkProperties dingtalkProperties;
    private final UserAccountGrantFlowService userAccountGrantFlowService;
    private final RedisStringAdapter redisStringAdapter;

    @Override
    public Long getUniquelyId() {
        return this.nextId();
    }

    @Override
    public CashDTO doSendCash(CashParam cashParam, AdminUser adminUser) {
        CashDTO result = new CashDTO();
        List<BaseCashParam.UserCash> userCashes = this.sendCashConvert.convert(cashParam);
        List<Long> notExitIds = this.checkUserExits(userCashes);
        if (CollectionUtils.isNotEmpty(notExitIds)) {
            result.setSuccessCode(Integer.valueOf(1));
            result.setNotExitIds(notExitIds);
        } else {
            this.grantCashAction(userCashes, cashParam, result, adminUser);
        }
        return result;
    }

    private CashDTO grantCashAction(List<BaseCashParam.UserCash> userCashes, CashParam cashParam, CashDTO result, AdminUser adminUser) {
        double cashNum = userCashes.stream().mapToDouble(BaseCashParam.UserCash::getCashNum).sum();
        if (cashNum < 1000.0) {
            this.sendCash(userCashes, cashParam, result, adminUser);
        } else {
            String verifyCode = this.redisStringAdapter.getString(this.getVerifyCodeKey(cashParam));
            if (StringUtils.isNotBlank((CharSequence)verifyCode)) {
                if (StringUtils.isNotBlank((CharSequence)cashParam.getVerifyCode())) {
                    if (verifyCode.equalsIgnoreCase(cashParam.getVerifyCode())) {
                        this.sendCash(userCashes, cashParam, result, adminUser);
                        this.redisStringAdapter.remove(this.getVerifyCodeKey(cashParam));
                    } else {
                        result.setSuccessCode(Integer.valueOf(3));
                    }
                } else {
                    result.setSuccessCode(Integer.valueOf(2));
                }
            } else {
                this.sendVerifyCode(cashParam, cashNum, userCashes.size());
                result.setSuccessCode(Integer.valueOf(2));
            }
        }
        return result;
    }

    private void sendVerifyCode(CashParam cashParam, double cashNum, int peopleNum) {
        String verifyCode = RandomStringUtils.random((int)4, (boolean)false, (boolean)true);
        StringBuilder content = new StringBuilder();
        content.append("\u3010\u73b0\u91d1\u53d1\u653e\u9a8c\u8bc1\u7801:").append(verifyCode).append(",\u603b\u8ba1").append(cashNum).append("\u73b0\u91d1, \u5171").append(peopleNum).append("\u4eba ").append("\uff0c\u5907\u6ce8\uff1a").append(cashParam.getRemake() == null ? "" : cashParam.getRemake()).append("\u3011");
        JSONObject text = new JSONObject();
        text.put("content", (Object)content);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", (Object)"text");
        msg.put("text", (Object)text);
        String response = this.httpClientService.doPostJson(this.dingtalkProperties.getVerifyCodeWebhook(), msg.toJSONString());
        this.logger.debug("dingding response:{}", (Object)response);
        this.redisStringAdapter.set(this.getVerifyCodeKey(cashParam), (Object)verifyCode, 900L);
    }

    private KeyGenerator getVerifyCodeKey(CashParam cashParam) {
        KeyGenerator flowerKey = RedisConfig.GRANT_CASH_FLOWER.copy();
        BaseFlowerParam param = new BaseFlowerParam();
        BeanUtils.copyProperties((Object)cashParam, (Object)param);
        int code = param.hashCode();
        KeyGenerator keyGenerator = flowerKey.appendKey((Object)code);
        return keyGenerator;
    }

    private void sendCash(List<BaseCashParam.UserCash> userCashes, CashParam cashParam, CashDTO result, AdminUser adminUser) {
        String url = "wst://mine/totalEarnings";
        userCashes.stream().forEach(e -> {
            BigDecimal cash = BigDecimal.valueOf(e.getCashNum()).setScale(2, 1);
            AccountCashParam param = new AccountCashParam();
            param.setContent(cashParam.getFlowType());
            param.setUserId(e.getUserId());
            param.setCash(cash);
            param.setAddTotal(Boolean.valueOf(true));
            param.setCashType(CashEnum.DRAWABLEL_CASH.name());
            param.setCashFlowType(CashFlowTypeEnum.OTHER.getName());
            param.setRemake(cashParam.getFlowType());
            this.userAccountIntegrationService.addCash(param);
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
            info.addExtend("msgId", (Object)this.nextId());
            info.addExtend("url", (Object)url);
            PushMessage message = PushMessage.build();
            message.setTitle(cashParam.getFlowType());
            message.setContent(cashParam.getContent());
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)e.getUserId()));
            message.setPayloadInfo(info);
            this.messageSender.sendPushMessage(message);
            UserAccountGrantFlow userAccountGrantFlow = new UserAccountGrantFlow();
            userAccountGrantFlow.setType(UserGrantFlowTypeEnum.CASH.getType());
            userAccountGrantFlow.setChangeType(UserGrantChangeTypeEnum.INCOME.getType());
            userAccountGrantFlow.setId(this.getUniquelyId());
            userAccountGrantFlow.setUserId(e.getUserId());
            userAccountGrantFlow.setRemake(cashParam.getRemake());
            userAccountGrantFlow.setCashAmount(cash);
            userAccountGrantFlow.setContent(cashParam.getContent());
            userAccountGrantFlow.setFlowType(cashParam.getFlowType());
            userAccountGrantFlow.setCreateTime(new Date());
            userAccountGrantFlow.setOperatorId(adminUser.getId());
            userAccountGrantFlow.setOperatorName(adminUser.getName());
            this.userAccountGrantFlowMapper.insertSelective(userAccountGrantFlow);
        });
        result.setSuccessCode(Integer.valueOf(0));
    }

    private List<Long> checkUserExits(List<BaseCashParam.UserCash> userFlowers) {
        ArrayList result = Lists.newArrayList();
        userFlowers.forEach(e -> {
            User user = this.userMapper.selectByUserId(e.getUserId().longValue());
            if (Objects.isNull(user) || user.getState() != 1) {
                result.add(e.getUserId());
            }
        });
        return result;
    }

    @Override
    public PageWarper<UserAccountGrantFlow> listFlower(UserAccountGrantFlowParam pageParam) {
        pageParam.setType(UserGrantFlowTypeEnum.CASH.getType());
        return new PageWarper(this.userAccountGrantFlowService.listFlower(pageParam));
    }

    public GiveOutCashServiceImpl(SendCashConvert sendCashConvert, UserMapper userMapper, UserAccountGrantFlowMapper userAccountGrantFlowMapper, MessageSender messageSender, UserAccountIntegrationService userAccountIntegrationService, HttpClientService httpClientService, DingtalkProperties dingtalkProperties, UserAccountGrantFlowService userAccountGrantFlowService, RedisStringAdapter redisStringAdapter) {
        this.sendCashConvert = sendCashConvert;
        this.userMapper = userMapper;
        this.userAccountGrantFlowMapper = userAccountGrantFlowMapper;
        this.messageSender = messageSender;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.httpClientService = httpClientService;
        this.dingtalkProperties = dingtalkProperties;
        this.userAccountGrantFlowService = userAccountGrantFlowService;
        this.redisStringAdapter = redisStringAdapter;
    }
}

