/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.localnews.admin.domain.InviteRecordMapper;
import com.bxm.localnews.admin.domain.UserAccountMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.domain.WithdrawMapper;
import com.bxm.localnews.admin.dto.BountyDTO;
import com.bxm.localnews.admin.dto.WithdrawFlowDTO;
import com.bxm.localnews.admin.dto.WithdrawUserInfo;
import com.bxm.localnews.admin.enums.InviteRecordStateEnum;
import com.bxm.localnews.admin.enums.InviteRecordStatusEnum;
import com.bxm.localnews.admin.enums.WithdrawEnum;
import com.bxm.localnews.admin.integration.WithdrawIntegrationService;
import com.bxm.localnews.admin.param.InviteRecordParam;
import com.bxm.localnews.admin.param.WithdrawParam;
import com.bxm.localnews.admin.service.activity.WithdrawService;
import com.bxm.localnews.admin.utils.IPUtil;
import com.bxm.localnews.admin.vo.InviteRecord;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.UserAccount;
import com.bxm.localnews.admin.vo.UserLoginHistory;
import com.bxm.localnews.admin.vo.WithdrawFlow;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.vo.IP;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WithdrawServiceImpl
implements WithdrawService {
    private static final Logger log = LoggerFactory.getLogger(WithdrawServiceImpl.class);
    @Autowired
    private WithdrawMapper withdrawMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserAccountMapper userAccountMapper;
    @Autowired
    private InviteRecordMapper inviteRecordMapper;
    @Autowired
    private IPUtil ipUtil;
    @Autowired
    private WithdrawIntegrationService withdrawIntegrationService;

    @Override
    public PageWarper<WithdrawFlowDTO> getWithdrawList(WithdrawParam withdrawParam) {
        Date now = new Date();
        withdrawParam.setAbortTime(DateUtils.formatAtWill((Date)now, (String)"yyyy-MM-dd HH:mm:ss"));
        PageWarper pageWarper = new PageWarper(this.withdrawMapper.queryWithdrawList(withdrawParam));
        pageWarper.getList().forEach(withdrawFlowDTO -> {
            User user = this.userMapper.selectByUserId(withdrawFlowDTO.getUserId().longValue());
            if (user != null) {
                IP clientIp = this.ipUtil.find(withdrawFlowDTO.getClientIp());
                withdrawFlowDTO.setClientIp(withdrawFlowDTO.getClientIp() + "<br/>" + clientIp.getProvince() + " " + clientIp.getCity());
                withdrawFlowDTO.setEquipment(user.getEquipment());
                withdrawFlowDTO.setNickname(user.getNickname());
                withdrawFlowDTO.setStateDesc(WithdrawEnum.getWithdrawEnumByState((Byte)withdrawFlowDTO.getState()).getDesc());
                UserAccount userAccount = this.userAccountMapper.getUserAccount(withdrawFlowDTO.getUserId());
                withdrawFlowDTO.setAccountInfo(userAccount.getWithdrawalCash().setScale(2, 4) + "/" + userAccount.getTotalCash().setScale(2, 4));
            }
        });
        return pageWarper;
    }

    @Override
    public WithdrawUserInfo getWithdrawUserInfo(Long id) {
        WithdrawFlow withdrawFlow = this.getWithdraw(id);
        if (withdrawFlow == null) {
            log.error("\u5f53\u524d\u8ba2\u5355\u7684\u63d0\u73b0\u7528\u6237\u76f8\u5173\u4fe1\u606f\u4e0d\u5b58\u5728");
            return null;
        }
        return this.generateWithdrawUserInfo(withdrawFlow.getUserId(), withdrawFlow.getPayAccount());
    }

    private WithdrawUserInfo generateWithdrawUserInfo(Long userId, String openId) {
        UserAccount userAccount;
        WithdrawUserInfo withdrawUserInfo = new WithdrawUserInfo();
        User user = this.userMapper.selectByUserId(userId.longValue());
        if (user == null) {
            log.error("\u7528\u6237[{}]\u4e0d\u5b58\u5728", (Object)userId);
            return null;
        }
        withdrawUserInfo.setUserId(userId);
        withdrawUserInfo.setNickname(user.getNickname());
        withdrawUserInfo.setPhone(user.getPhone());
        withdrawUserInfo.setOpenId(openId);
        String registerName = "";
        if (StringUtils.isNotEmpty((CharSequence)user.getRegisterChannel())) {
            registerName = InviteTypeEnum.valueOf((String)user.getRegisterChannel()).getDesc();
        }
        withdrawUserInfo.setRegisterChannel(user.getRegisteredAddress() + "" + registerName);
        if (StringUtils.isEmpty((CharSequence)user.getRegisteredAddress())) {
            withdrawUserInfo.setRegisterChannel("");
        }
        withdrawUserInfo.setChannel(user.getChannelName());
        withdrawUserInfo.setCreateTime(user.getCreateTime());
        withdrawUserInfo.setEquipment(user.getEquipment());
        IP regIp = this.ipUtil.find(user.getRegIp());
        withdrawUserInfo.setRegIp(user.getRegIp() + " " + regIp.getProvince() + " " + regIp.getCity());
        withdrawUserInfo.setAreaName(this.userMapper.selectLocationByUserId(userId.longValue()));
        UserLoginHistory userLoginHistory = this.userMapper.selectHistoryByUserId(userId.longValue());
        if (userLoginHistory != null) {
            IP historyIp = this.ipUtil.find(userLoginHistory.getLastLoginIp());
            withdrawUserInfo.setLastLoginIp(userLoginHistory.getLastLoginIp() + " " + historyIp.getProvince() + " " + historyIp.getCity());
            withdrawUserInfo.setLastLginTime(userLoginHistory.getLastLoginTime());
            withdrawUserInfo.setLastLoginEquipment(userLoginHistory.getEquipment());
        }
        if ((userAccount = this.userAccountMapper.getUserAccount(userId)) != null) {
            withdrawUserInfo.setDrawablelCash(userAccount.getDrawablelCash());
            withdrawUserInfo.setTotalCash(userAccount.getTotalCash());
            withdrawUserInfo.setWithdrawalCash(userAccount.getWithdrawalCash());
        }
        List<InviteRecord> inviteRecords = this.getUserAllInviteRecordByCash(userId);
        BountyDTO bountyDTO = this.generateBounty(inviteRecords);
        withdrawUserInfo.setAvailableCash(bountyDTO.getAvailableCash());
        withdrawUserInfo.setDiscardCash(bountyDTO.getDiscardCash());
        withdrawUserInfo.setSuccessInviteNum(Integer.valueOf(inviteRecords.size()));
        return withdrawUserInfo;
    }

    @Override
    public void userPassWithdrawal(Long id) {
        try {
            WithdrawFlow withdrawFlow = this.getWithdraw(id);
            if (withdrawFlow == null) {
                log.error("id\u4e3a[{}]\u7684\u63d0\u73b0\u8ba2\u5355\u4e0d\u5b58\u5728", (Object)id);
                return;
            }
            if (WithdrawEnum.SUCCESS_PAYMENT.getState().equals(withdrawFlow.getState()) || WithdrawEnum.FAIL_PAYMENT.getState().equals(withdrawFlow.getState()) || WithdrawEnum.DURING_PAYMENT.getState().equals(withdrawFlow.getState())) {
                log.error("id\u4e3a[{}]\u7684\u63d0\u73b0\u8ba2\u5355\u5df2\u8fdb\u884c\u5904\u7406\uff0c\u72b6\u6001\u4e3a[{}]\uff0c\u540e\u53f0\u4e0d\u4e88\u5904\u7406", (Object)id, (Object)withdrawFlow.getState());
                return;
            }
            log.info("id\u4e3a[{}]\u7684\u63d0\u73b0\u8ba2\u5355\u72b6\u6001\u4e3a[{}]\uff0c\u5f53\u524d\u64cd\u4f5c\u76f4\u63a5\u63d0\u73b0\u5230\u5fae\u4fe1", (Object)id, (Object)withdrawFlow.getState());
            withdrawFlow.setState(WithdrawEnum.DURING_PAYMENT.getState());
            this.withdrawMapper.updateWithdrawFlow(withdrawFlow);
            withdrawFlow.setWithdrawType(Byte.valueOf((byte)1));
            this.withdrawIntegrationService.userWithdraw(withdrawFlow);
        }
        catch (Exception e) {
            log.error("\u63d0\u73b0\u5931\u8d25: {}", (Object)id, (Object)e);
        }
    }

    @Override
    public void userCheckWithdrawal(Long id) {
        WithdrawFlow withdrawFlow = this.getWithdraw(id);
        if (withdrawFlow == null) {
            return;
        }
        withdrawFlow.setState(WithdrawEnum.DELAY_AUDIT.getState());
        this.withdrawMapper.updateWithdrawFlow(withdrawFlow);
    }

    private WithdrawFlow getWithdraw(Long id) {
        return this.withdrawMapper.getWithdraw(id);
    }

    private List<InviteRecord> getUserAllInviteRecordByCash(Long userId) {
        InviteRecordParam inviteRecordParam = new InviteRecordParam();
        inviteRecordParam.setUserId(userId);
        inviteRecordParam.setAwardType("CASH");
        inviteRecordParam.setAward(BigDecimal.ZERO);
        inviteRecordParam.setStatus(Byte.valueOf((byte)1));
        return this.inviteRecordMapper.queryUserInviteRecord(inviteRecordParam);
    }

    private BountyDTO generateBounty(List<InviteRecord> inviteRecords) {
        List<InviteRecord> invalidList;
        BountyDTO bountyDTO = new BountyDTO();
        if (CollectionUtils.isEmpty(inviteRecords)) {
            return bountyDTO;
        }
        List<InviteRecord> validList = this.filterValid(inviteRecords);
        if (!CollectionUtils.isEmpty(validList)) {
            ArrayList availableCashList = Lists.newArrayList();
            BigDecimal availableCash = BigDecimal.ZERO;
            for (InviteRecord inviteRecord : validList) {
                if (InviteRecordStateEnum.ACCEPT_INVITE.getName().equals(inviteRecord.getInviteState())) {
                    inviteRecord.setInviteState(InviteRecordStateEnum.ACCEPT_INVITE.getDesc());
                    availableCashList.add(inviteRecord);
                }
                availableCash = availableCash.add(inviteRecord.getAward());
            }
            for (InviteRecord inviteRecord : validList) {
                if (!InviteRecordStateEnum.LOGIN_APP.getName().equals(inviteRecord.getInviteState())) continue;
                inviteRecord.setInviteState(InviteRecordStateEnum.LOGIN_APP.getDesc());
                availableCashList.add(inviteRecord);
            }
            bountyDTO.setAvailableCash(availableCash);
        }
        if (!CollectionUtils.isEmpty(invalidList = this.filterInValid(inviteRecords))) {
            ArrayList discardCashList = Lists.newArrayList();
            BigDecimal discardCash = BigDecimal.ZERO;
            for (InviteRecord inviteRecord : invalidList) {
                if (InviteRecordStateEnum.OVERDUE_INVALID.getName().equals(inviteRecord.getInviteState())) {
                    inviteRecord.setInviteState(InviteRecordStateEnum.OVERDUE_INVALID.getDesc());
                }
                if (InviteRecordStateEnum.NOT_NEW_USER.getName().equals(inviteRecord.getInviteState())) {
                    inviteRecord.setInviteState(InviteRecordStateEnum.NOT_NEW_USER.getDesc());
                }
                discardCashList.add(inviteRecord);
                discardCash = discardCash.add(inviteRecord.getAward());
            }
            bountyDTO.setDiscardCash(discardCash);
        }
        return bountyDTO;
    }

    private List<InviteRecord> filterValid(List<InviteRecord> inviteRecords) {
        List<InviteRecord> validList = inviteRecords.stream().filter(inviteRecord -> InviteRecordStatusEnum.VALID.getStatus().equals(inviteRecord.getStatus()) && !InviteRecordStateEnum.SUCCESS_WITHDRAW.getName().equals(inviteRecord.getInviteState())).collect(Collectors.toList());
        return validList;
    }

    private List<InviteRecord> filterInValid(List<InviteRecord> inviteRecords) {
        List<InviteRecord> invalidList = inviteRecords.stream().filter(inviteRecord -> InviteRecordStatusEnum.INVALID.getStatus().equals(inviteRecord.getStatus())).collect(Collectors.toList());
        return invalidList;
    }

    private List<InviteRecord> filterObtain(List<InviteRecord> inviteRecords) {
        List<InviteRecord> obtainList = inviteRecords.stream().filter(inviteRecord -> InviteRecordStatusEnum.VALID.getStatus().equals(inviteRecord.getStatus()) && InviteRecordStateEnum.SUCCESS_WITHDRAW.getName().equals(inviteRecord.getInviteState())).collect(Collectors.toList());
        return obtainList;
    }
}

