/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.strategy;

import com.bxm.localnews.admin.service.activity.strategy.PushCodeService;
import com.bxm.localnews.admin.vo.AreaPushCode;
import com.bxm.newidea.component.vo.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PushCodeDispatcher
implements InitializingBean,
ApplicationContextAware,
PushCodeService {
    private static final Logger log = LoggerFactory.getLogger(PushCodeDispatcher.class);
    private ApplicationContext applicationContext;
    private Map<String, PushCodeService> strategyMap;

    public void afterPropertiesSet() {
        this.strategyMap = this.applicationContext.getBeansOfType(PushCodeService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Message execPushCode(AreaPushCode areaPushCode, String codeUrl) {
        String templateCode = areaPushCode.getCodeTemplate();
        PushCodeService pushCodeService = this.strategyMap.get(templateCode);
        if (null == pushCodeService) {
            log.error("\u914d\u7f6e\u7684\u7b56\u7565[" + templateCode + "]\u4e0d\u5b58\u5728");
            return null;
        }
        return this.strategyMap.get(templateCode).execPushCode(areaPushCode, codeUrl);
    }
}

