/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.config.InviteShareProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AdminAdvertAreaMapper;
import com.bxm.localnews.admin.domain.AdvertMaterialMapper;
import com.bxm.localnews.admin.domain.AdvertPositionMapper;
import com.bxm.localnews.admin.domain.AdvertPositionRelationMapper;
import com.bxm.localnews.admin.dto.AdvertAreaDTO;
import com.bxm.localnews.admin.dto.AdvertDeliveryObjectDTO;
import com.bxm.localnews.admin.dto.AdvertMaterialDTO;
import com.bxm.localnews.admin.dto.AdvertMaterialInfo;
import com.bxm.localnews.admin.dto.AdvertPositionDTO;
import com.bxm.localnews.admin.dto.AdvertTypeDTO;
import com.bxm.localnews.admin.dto.InviteSharePositionDTO;
import com.bxm.localnews.admin.enums.AdvertTypeEnum;
import com.bxm.localnews.admin.enums.AreaWhiteBlackKeyEnum;
import com.bxm.localnews.admin.enums.FollowSelectEnum;
import com.bxm.localnews.admin.param.AdvertMaterialParam;
import com.bxm.localnews.admin.param.AdvertPositionParam;
import com.bxm.localnews.admin.service.base.AdvertisementService;
import com.bxm.localnews.admin.vo.AdvertArea;
import com.bxm.localnews.admin.vo.AdvertMaterial;
import com.bxm.localnews.admin.vo.AdvertMaterialWithRelation;
import com.bxm.localnews.admin.vo.AdvertPosition;
import com.bxm.localnews.admin.vo.AdvertPositionRelation;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AdvertisementServiceImpl
implements AdvertisementService {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(AdvertisementServiceImpl.class);
    private static final Logger LOG = LoggerFactory.getLogger(AdvertisementServiceImpl.class);
    @Resource
    private AdvertMaterialMapper advertMaterialMapper;
    @Resource
    private AdvertPositionMapper advertPositionMapper;
    @Resource
    private AdvertPositionRelationMapper advertPositionRelationMapper;
    @Resource
    private AdminAdvertAreaMapper advertAreaMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private InviteShareProperties inviteShareProperties;

    @Override
    public int updateMaterialStatus(Long id, Integer status) {
        AdvertMaterial advertMaterial = new AdvertMaterial();
        advertMaterial.setId(id);
        advertMaterial.setMaterialStatus(status);
        int update = this.advertMaterialMapper.updateByPrimaryKeySelective(advertMaterial);
        this.delAdvertCacheWithMaterial(id);
        return update;
    }

    @Override
    public int addAdvertisementMaterial(AdvertMaterialParam advertMaterialParam) {
        AdvertMaterial advertMaterial = new AdvertMaterial();
        BeanUtils.copyProperties((Object)advertMaterialParam, (Object)advertMaterial);
        advertMaterial.setAddress(this.dealUrl(advertMaterialParam));
        int insert = this.advertMaterialMapper.insertSelective(advertMaterial);
        this.delAdvertCacheWithMaterial(advertMaterialParam.getId());
        return insert;
    }

    private String dealUrl(AdvertMaterialParam addParam) {
        if (addParam.getFollowAct().equals(FollowSelectEnum.NULL_FOLLOW_SELECTION.getIndex())) {
            return null;
        }
        if (addParam.getFollowAct().equals(FollowSelectEnum.OPEN_COMMODITY.getIndex())) {
            return "wst://goods/goodsDetail?goodsId=" + addParam.getFollowContent();
        }
        if (addParam.getFollowAct().equals(FollowSelectEnum.JUMP_LINK.getIndex())) {
            return addParam.getFollowContent();
        }
        if (addParam.getFollowAct().equals(FollowSelectEnum.JUMP_SEARCH.getIndex())) {
            try {
                return "wst://goods/goodsSearch?keyword=" + URLEncoder.encode(StringUtils.isEmpty((Object)addParam.getFollowContent()) ? addParam.getMaterialContent() : addParam.getFollowContent(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn("\u7d20\u6750\u6dfb\u52a0\u8df3\u8f6c\u641c\u7d22\u94fe\u63a5\u7f16\u7801\u5931\u8d25\uff0c\u70ed\u8bcd\u4e3a\uff1a{}", (Object)addParam.getFollowContent());
                e.printStackTrace();
            }
        }
        if (addParam.getFollowAct().equals(FollowSelectEnum.TAO_BAO_UNION_ACTION.getIndex())) {
            return addParam.getFollowContent();
        }
        return null;
    }

    @Override
    public int modifyAdvertisementMaterial(AdvertMaterialParam advertMaterialParam) {
        AdvertMaterial advertMaterial = new AdvertMaterial();
        BeanUtils.copyProperties((Object)advertMaterialParam, (Object)advertMaterial);
        LOG.info("\u66f4\u6539\u5e7f\u544a\u7d20\u6750\u4fe1\u606f,\u66f4\u6539\u7684\u5185\u5bb9\u4e3a:{}", (Object)JSON.toJSONString((Object)advertMaterial));
        advertMaterial.setAddress(this.dealUrl(advertMaterialParam));
        int update = this.advertMaterialMapper.updateByPrimaryKeySelective(advertMaterial);
        this.delAdvertCacheWithMaterial(advertMaterialParam.getId());
        return update;
    }

    @Override
    public AdvertMaterialDTO getAdvertisementMaterialInfo(Long id) {
        AdvertMaterial advertMaterial = this.advertMaterialMapper.selectByPrimaryKey(id);
        if (null == advertMaterial) {
            LOG.error("\u6839\u636eid:{}\u83b7\u53d6\u7684\u5e7f\u544a\u7d20\u6750\u8be6\u60c5\u4e3a\u7a7a", (Object)id);
            return null;
        }
        AdvertMaterialDTO advertMaterialDTO = new AdvertMaterialDTO();
        BeanUtils.copyProperties((Object)advertMaterial, (Object)advertMaterialDTO);
        return advertMaterialDTO;
    }

    @Override
    public int delAdvertisementMaterial(Long id) {
        int delete = this.advertMaterialMapper.deleteByPrimaryKey(id);
        this.delAdvertCacheWithMaterial(id);
        return delete;
    }

    @Override
    public PageWarper<AdvertMaterialDTO> queryMaterialList(AdvertMaterialParam advertMaterialParam) {
        AdvertMaterial advertMaterial = new AdvertMaterial();
        BeanUtils.copyProperties((Object)advertMaterialParam, (Object)advertMaterial);
        PageInfo pageInfo = new PageInfo(this.advertMaterialMapper.queryAdvertMaterialList(advertMaterial));
        ArrayList advertMaterialResultList = new ArrayList();
        pageInfo.getList().forEach(advertMaterialResult -> {
            AdvertMaterialDTO advertMaterialResultDTO = new AdvertMaterialDTO();
            BeanUtils.copyProperties((Object)advertMaterialResult, (Object)advertMaterialResultDTO);
            advertMaterialResultList.add(advertMaterialResultDTO);
        });
        PageWarper resultInfo = new PageWarper(advertMaterialResultList);
        resultInfo.setPageNum(pageInfo.getPageNum());
        resultInfo.setPageSize(pageInfo.getPageSize());
        resultInfo.setTotal(pageInfo.getTotal());
        return resultInfo;
    }

    @Override
    public int updatePositionStatus(Long id, Integer status) {
        AdvertPosition advertPosition = new AdvertPosition();
        advertPosition.setId(id);
        advertPosition.setEnableStatus(status);
        int update = this.advertPositionMapper.updateByPrimaryKeySelective(advertPosition);
        this.delAdvertCache(this.advertPositionMapper.selectByPrimaryKey(id).getPositionType());
        return update;
    }

    @Override
    public boolean addAdvertisementPosition(AdvertPositionParam advertPositionParam) {
        Long positionId = this.sequenceCreater.nextLongId();
        AdvertPosition advertPosition = new AdvertPosition();
        BeanUtils.copyProperties((Object)advertPositionParam, (Object)advertPosition);
        advertPosition.setId(positionId);
        this.advertPositionMapper.insertSelective(advertPosition);
        this.addMaterialWithPositionInfo(positionId, advertPositionParam.getMaterialList());
        this.editAreaInfo(positionId, advertPositionParam.getAreaList());
        this.delAdvertCache(advertPositionParam.getPositionType());
        return true;
    }

    @Override
    public boolean editAdvertisementPosition(AdvertPositionParam advertPositionParam) {
        AdvertPosition advertPosition = new AdvertPosition();
        BeanUtils.copyProperties((Object)advertPositionParam, (Object)advertPosition);
        int positionAddResult = this.advertPositionMapper.updateByPrimaryKeySelective(advertPosition);
        if (0 > positionAddResult) {
            LOG.error("\u66f4\u65b0\u5e7f\u544a\u7d20\u6750\u6295\u653e\u5931\u8d25,\u66f4\u65b0\u7684\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)advertPosition));
            return false;
        }
        this.editMaterialWithPositionInfo(advertPositionParam.getId(), advertPositionParam.getMaterialList());
        this.editAreaInfo(advertPositionParam.getId(), advertPositionParam.getAreaList());
        this.delAdvertCache(advertPositionParam.getPositionType());
        return true;
    }

    @Override
    public AdvertPositionDTO getAdvertPositionDetail(Long positionId) {
        AdvertPosition advertPosition = this.advertPositionMapper.selectByPrimaryKey(positionId);
        if (null == advertPosition) {
            LOG.error("\u6839\u636eid:{}\u83b7\u53d6\u6295\u653e\u8be6\u60c5\u4e3a\u7a7a", (Object)positionId);
            return null;
        }
        AdvertPositionDTO resultDTO = new AdvertPositionDTO();
        BeanUtils.copyProperties((Object)advertPosition, (Object)resultDTO);
        List<AdvertMaterialInfo> advertMaterialInfoList = this.getMaterialByPositionId(positionId);
        resultDTO.setMaterialList(advertMaterialInfoList);
        List areaInfoList = this.advertAreaMapper.getAdvertAreaList(positionId);
        resultDTO.setAreaList(areaInfoList);
        return resultDTO;
    }

    @Override
    public boolean delAdvertPosition(Long positionId, Integer positionType) {
        int positionDelResult = this.advertPositionMapper.deleteByPrimaryKey(positionId);
        if (1 != positionDelResult) {
            LOG.error("\u5220\u9664position\u8868\u5931\u8d25,positionId\u4e3a:{}", (Object)positionId);
            return false;
        }
        this.advertPositionRelationMapper.deleteByPositionId(positionId);
        this.advertAreaMapper.deleteByAdvertId(positionId);
        if (null != positionType) {
            this.delAdvertCache(positionType);
        }
        return true;
    }

    @Override
    public PageWarper<AdvertPositionDTO> queryPositionList(AdvertPositionParam advertPositionParam) {
        AdvertPosition advertPosition = new AdvertPosition();
        BeanUtils.copyProperties((Object)advertPositionParam, (Object)advertPosition);
        PageInfo pageInfo = new PageInfo(this.advertPositionMapper.queryAdvertPositionList(advertPosition));
        ArrayList resultList = new ArrayList();
        pageInfo.getList().forEach(positionQueryResult -> {
            AdvertPositionDTO resultDTO = new AdvertPositionDTO();
            BeanUtils.copyProperties((Object)positionQueryResult, (Object)resultDTO);
            List areaList = this.advertAreaMapper.getAdvertAreaList(positionQueryResult.getId());
            resultDTO.setAreaList(areaList);
            resultDTO.setPositionTypeStr(AdvertTypeEnum.getNameByCode((int)positionQueryResult.getPositionType()));
            resultList.add(resultDTO);
        });
        PageWarper resultInfo = new PageWarper(resultList);
        resultInfo.setPageNum(pageInfo.getPageNum());
        resultInfo.setPageSize(pageInfo.getPageSize());
        resultInfo.setTotal(pageInfo.getTotal());
        return resultInfo;
    }

    @Override
    public List<Long> getRelationListByMaterialId(Long materialId) {
        return this.advertPositionRelationMapper.selectByMaterialId(materialId);
    }

    @Override
    public List<AdvertMaterialDTO> getAllMaterial(String key) {
        List queryResultList = this.advertMaterialMapper.queryAllMaterial(key);
        ArrayList<AdvertMaterialDTO> resultDTO = new ArrayList<AdvertMaterialDTO>();
        queryResultList.forEach(advertMaterial -> {
            AdvertMaterialDTO advertMaterialDTO = new AdvertMaterialDTO();
            BeanUtils.copyProperties((Object)advertMaterial, (Object)advertMaterialDTO);
            advertMaterialDTO.setMaterialName(advertMaterialDTO.getId() + "_" + advertMaterialDTO.getMaterialName());
            resultDTO.add(advertMaterialDTO);
        });
        return resultDTO;
    }

    @Override
    public List<AdvertTypeDTO> getAllAdvertType() {
        return AdvertTypeEnum.getAllType();
    }

    @Override
    public List<AdvertDeliveryObjectDTO> listAdvertDeliveryObject() {
        ArrayList<AdvertDeliveryObjectDTO> advertDeliveryObjectDtoList = new ArrayList<AdvertDeliveryObjectDTO>();
        for (InviteTypeEnum rate : InviteTypeEnum.values()) {
            advertDeliveryObjectDtoList.add(new AdvertDeliveryObjectDTO(rate.getName(), rate.getDesc()));
        }
        return advertDeliveryObjectDtoList;
    }

    @Override
    public List<InviteSharePositionDTO> listAllInviteSharePosition() {
        return this.inviteShareProperties.getPositions();
    }

    @Override
    public void offlineAdvertPosition() {
        List advertPositions = this.advertPositionMapper.queryAdvertPositionListByStatus(Integer.valueOf(1));
        advertPositions.forEach(ad -> {
            Date nowTime = new Date();
            Date endTime = ad.getEndTime();
            if (endTime != null && endTime.before(nowTime)) {
                this.advertPositionMapper.updateAdvertPositionStatus(ad.getId(), Integer.valueOf(0));
            }
        });
    }

    private void addMaterialWithPositionInfo(Long advertPositionId, List<AdvertMaterialInfo> materialList) {
        this.advertPositionRelationMapper.deleteByPrimaryKey(advertPositionId);
        if (CollectionUtils.isEmpty(materialList)) {
            LOG.error("\u7d20\u6750\u5217\u8868\u4e3a\u7a7a,\u5e7f\u544a\u6295\u653eid\u4e3a:{}", (Object)advertPositionId);
            return;
        }
        for (AdvertMaterialInfo advertMaterialInfo : materialList) {
            AdvertPositionRelation advertPositionRelation = new AdvertPositionRelation();
            advertPositionRelation.setPositionId(advertPositionId);
            advertPositionRelation.setMaterialId(advertMaterialInfo.getId());
            advertPositionRelation.setMaterialOrder(advertMaterialInfo.getAdvertOrder());
            advertPositionRelation.setPreconditions(advertMaterialInfo.getPreconditions());
            advertPositionRelation.setNeedPop(advertMaterialInfo.getNeedPop());
            this.advertPositionRelationMapper.insertSelective(advertPositionRelation);
        }
    }

    private void editMaterialWithPositionInfo(Long advertPositionId, List<AdvertMaterialInfo> materialList) {
        this.advertPositionRelationMapper.deleteByPositionId(advertPositionId);
        for (AdvertMaterialInfo advertMaterialInfo : materialList) {
            AdvertPositionRelation advertPositionRelation = new AdvertPositionRelation();
            advertPositionRelation.setPositionId(advertPositionId);
            advertPositionRelation.setMaterialOrder(advertMaterialInfo.getAdvertOrder());
            advertPositionRelation.setMaterialId(advertMaterialInfo.getId());
            advertPositionRelation.setPreconditions(advertMaterialInfo.getPreconditions());
            advertPositionRelation.setNeedPop(advertMaterialInfo.getNeedPop());
            this.advertPositionRelationMapper.insertSelective(advertPositionRelation);
        }
    }

    private void editAreaInfo(Long positionId, List<AdvertAreaDTO> advertAreaDTOList) {
        this.advertAreaMapper.deleteByAdvertId(positionId);
        if (CollectionUtils.isEmpty(advertAreaDTOList)) {
            LOG.error("\u5e7f\u544a\u5730\u533a\u76f8\u5173\u4fe1\u606f\u4e3a\u7a7a,\u5bf9\u5e94\u7684\u5e7f\u544a\u6295\u653eid\u4e3a:{}", (Object)positionId);
            return;
        }
        ArrayList<AdvertArea> advertAreaList = new ArrayList<AdvertArea>();
        for (AdvertAreaDTO advertAreaDTO : advertAreaDTOList) {
            AdvertArea advertAreaEntity = new AdvertArea();
            advertAreaEntity.setId(this.sequenceCreater.nextLongId());
            advertAreaEntity.setAdvertId(positionId);
            advertAreaEntity.setCode(advertAreaDTO.getAreaCode());
            advertAreaEntity.setAreaName(advertAreaDTO.getAreaName());
            advertAreaEntity.setAreaType(advertAreaDTO.getAreaType());
            advertAreaList.add(advertAreaEntity);
        }
        this.advertAreaMapper.insertAdvertAreas(advertAreaList);
    }

    private List<AdvertMaterialInfo> getMaterialByPositionId(Long positionId) {
        List materialList = this.advertPositionRelationMapper.selectByPositionId(positionId);
        ArrayList<AdvertMaterialInfo> advertMaterialInfoList = new ArrayList<AdvertMaterialInfo>();
        if (CollectionUtils.isNotEmpty((Collection)materialList)) {
            for (AdvertMaterialWithRelation advertMaterialWithRelation : materialList) {
                AdvertMaterialInfo advertMaterialInfo = new AdvertMaterialInfo();
                advertMaterialInfo.setId(advertMaterialWithRelation.getMaterialId());
                advertMaterialInfo.setMaterialName(advertMaterialWithRelation.getMaterialName());
                advertMaterialInfo.setAdvertOrder(advertMaterialWithRelation.getMaterialOrder());
                advertMaterialInfo.setPreconditions(advertMaterialWithRelation.getPreconditions());
                advertMaterialInfo.setNeedPop(advertMaterialWithRelation.getNeedPop());
                advertMaterialInfoList.add(advertMaterialInfo);
            }
        }
        return advertMaterialInfoList;
    }

    private void delAdvertCacheWithMaterial(Long materialId) {
        List positionIdList = this.advertPositionRelationMapper.selectByMaterialId(materialId);
        positionIdList.forEach(positionId -> {
            AdvertPosition advertPosition = this.advertPositionMapper.selectByPrimaryKey(positionId);
            this.delAdvertCache(advertPosition.getPositionType());
        });
    }

    private void delAdvertCache(Integer type) {
        LOG.info("\u6839\u636e\u6295\u653e\u7c7b\u578b\u5220\u9664\u7f13\u5b58,\u6295\u653e\u7c7b\u578b\u4e3a:{}", (Object)type);
        if (null != type) {
            this.redisHashMapAdapter.remove(RedisConfig.AREA_WHITE_BLACK_LIST.copy().appendKey((Object)(AreaWhiteBlackKeyEnum.ADVERT.getKey() + type)));
        }
    }
}

