/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.convert.impl.VirtualUserConverter;
import com.bxm.localnews.admin.convert.impl.VirtualUserInfoConverter;
import com.bxm.localnews.admin.domain.AdminUserMapper;
import com.bxm.localnews.admin.domain.AdminVirtualMapper;
import com.bxm.localnews.admin.domain.IMMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.dto.AdminVirtualUserDTO;
import com.bxm.localnews.admin.dto.ChatVirtualUserDTO;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.param.UserSyncParam;
import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.param.VirtualUserParam;
import com.bxm.localnews.admin.param.VirtualUserQueryParam;
import com.bxm.localnews.admin.service.base.UserTagService;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.vo.AdminVirtual;
import com.bxm.localnews.admin.vo.AllVirtureUserVo;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.common.constant.RedisMessageChannel;
import com.bxm.localnews.common.vo.RedisMessageBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class VirtualUserServiceImpl
extends BaseService
implements VirtualUserService {
    private UserMapper userMapper;
    private VirtualUserMapper virtualUserMapper;
    private VirtualUserConverter virtualUserConverter;
    private VirtualUserInfoConverter virtualUserInfoConverter;
    private RedisHashMapAdapter redisHashMapAdapter;
    private RedisStringAdapter redisStringAdapter;
    private UserTagService userTagService;
    private AdminVirtualMapper adminVirtualMapper;
    private AdminUserMapper adminUserMapper;
    private IMMapper imMapper;

    @Autowired
    public VirtualUserServiceImpl(UserMapper userMapper, VirtualUserMapper virtualUserMapper, VirtualUserConverter virtualUserConverter, VirtualUserInfoConverter virtualUserInfoConverter, RedisHashMapAdapter redisHashMapAdapter, RedisStringAdapter redisStringAdapter, UserTagService userTagService, AdminVirtualMapper adminVirtualMapper, AdminUserMapper adminUserMapper, IMMapper imMapper) {
        this.userMapper = userMapper;
        this.virtualUserMapper = virtualUserMapper;
        this.virtualUserConverter = virtualUserConverter;
        this.virtualUserInfoConverter = virtualUserInfoConverter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.userTagService = userTagService;
        this.adminVirtualMapper = adminVirtualMapper;
        this.adminUserMapper = adminUserMapper;
        this.imMapper = imMapper;
    }

    @Override
    public Long save(VirtualUserInfoParam virtualUser) {
        User user = this.virtualUserConverter.convert(virtualUser);
        VirtualUser virtualUserVo = this.virtualUserInfoConverter.convert(virtualUser);
        if (null == virtualUser.getId()) {
            this.userMapper.insertSelective(user);
            virtualUserVo.setId(user.getId());
            this.virtualUserMapper.insertSelective(virtualUserVo);
            this.userTagService.save(user.getId(), user.getUserTagIds());
        } else {
            this.userMapper.updateByPrimaryKeySelective(user);
            this.virtualUserMapper.updateByPrimaryKeySelective(virtualUserVo);
            this.userTagService.update(user.getId(), user.getUserTagIds());
            this.redisStringAdapter.remove(RedisConfig.USER_INFO.copy().appendKey((Object)virtualUser.getId()));
            this.redisHashMapAdapter.remove(RedisConfig.USER_TAG, new String[]{String.valueOf(virtualUser.getId())});
            UserSyncParam userSyncParam = new UserSyncParam().setHeadImg(virtualUser.getHeadImg()).setId(virtualUser.getId()).setNickname(virtualUser.getNickname()).setSex(virtualUser.getSex());
            this.syncUser(userSyncParam);
        }
        return user.getId();
    }

    private void syncUser(UserSyncParam user) {
        RedisMessageBean userSyncParamRedisMessageBean = new RedisMessageBean();
        userSyncParamRedisMessageBean.setEventBody((Object)user);
        userSyncParamRedisMessageBean.setCreateTime(new Date());
        userSyncParamRedisMessageBean.setEventCode(String.valueOf(RedisMessageChannel.USER_UPDATE_EVENT.getCode()));
        userSyncParamRedisMessageBean.setEventId(String.valueOf(this.nextSequence()));
        userSyncParamRedisMessageBean.setEventName(String.valueOf(RedisMessageChannel.USER_UPDATE_EVENT.getDesc()));
        this.logger.info("\u66f4\u65b0\u7528\u6237\u5197\u4f59\u4fe1\u606f,\u53d1\u9001redis\u6d88\u606f:[{}]", (Object)JSONObject.toJSONString((Object)user));
        this.redisStringAdapter.convertAndSend(RedisMessageChannel.USER_UPDATE_EVENT.getName(), JSONObject.toJSON((Object)userSyncParamRedisMessageBean));
    }

    @Override
    public PageWarper<AdminVirtualUserDTO> listByPage(VirtualUserParam virtualUserParam) {
        return new PageWarper(this.virtualUserMapper.queryPageSize(virtualUserParam));
    }

    @Override
    public List<VirtualUserOverviewDTO> list(VirtualUserQueryParam virtualUserQueryParam) {
        VirtualUser virtualUser = new VirtualUser();
        BeanUtils.copyProperties((Object)virtualUserQueryParam, (Object)virtualUser);
        List virtualUserList = this.virtualUserMapper.selectByModel(virtualUser);
        return virtualUserList.stream().map(e -> VirtualUserOverviewDTO.builder().id(e.getId()).headImg(e.getHeadImg()).nickname(e.getNickname()).userInfo(this.getUserInfo(e.getNickname() + "(" + this.getSex(e.getSex()), e.getRemark())).build()).collect(Collectors.toList());
    }

    @Override
    public VirtualUser getVirtualUserDetail(Long id) {
        String[] hometownCodeSplit;
        VirtualUser virtualUserParam = new VirtualUser();
        virtualUserParam.setId(id);
        List virtualUsers = this.virtualUserMapper.selectByModel(virtualUserParam);
        if (CollectionUtils.isEmpty((Collection)virtualUsers)) {
            return null;
        }
        VirtualUser virtualuser = (VirtualUser)virtualUsers.get(0);
        virtualuser.setUserTagIds(JSONObject.parseArray((String)virtualuser.getHobby(), Long.class));
        if (StringUtils.isNotBlank((CharSequence)virtualuser.getHometownCode()) && (hometownCodeSplit = virtualuser.getHometownCode().split("_")).length == 3) {
            virtualuser.setHometownCode(hometownCodeSplit[2]);
            virtualuser.setCountyCode(hometownCodeSplit[2]);
            virtualuser.setCityCode(hometownCodeSplit[1]);
            virtualuser.setProvinceCode(hometownCodeSplit[0]);
        }
        return virtualuser;
    }

    @Override
    @Cacheable(value={"listVirtualUser"}, sync=true)
    public Map<Long, VirtualUser> list() {
        VirtualUser virtualUser = new VirtualUser();
        List virtualUserList = this.virtualUserMapper.selectByModel(virtualUser);
        return virtualUserList.stream().collect(Collectors.toMap(VirtualUser::getId, Function.identity(), (key1, key2) -> key2));
    }

    @Override
    public Boolean changeVestControl(Long virtualUserId, Long adminUserId, AdminUser loginUser) {
        AdminVirtual admin = this.adminVirtualMapper.selectByVirtualUserId(virtualUserId);
        AdminUser adminUser = this.adminUserMapper.selectById(adminUserId);
        if (Objects.isNull(admin)) {
            AdminVirtual virtual = AdminVirtual.builder().id(Long.valueOf(this.nextId())).addTime(new Date()).modifyTime(new Date()).virtualUserId(virtualUserId).adminUserAccount(adminUser.getUsername()).adminUserId(adminUserId).operateUserId(loginUser.getId()).operateUserAccount(loginUser.getUsername()).build();
            this.adminVirtualMapper.insertSelective(virtual);
        } else {
            admin.setModifyTime(new Date());
            admin.setAdminUserId(adminUserId);
            admin.setVirtualUserId(virtualUserId);
            admin.setAdminUserAccount(adminUser.getUsername());
            this.adminVirtualMapper.updateByPrimaryKeySelective(admin);
        }
        return Boolean.TRUE;
    }

    @Override
    public List<ChatVirtualUserDTO> getVirtualList(AdminUser loginUser) {
        List list = this.virtualUserMapper.queryVirtualByAdminUserId(loginUser.getId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        Map<Long, Date> recentTimeMap = this.getRecentTime(list.stream().map(VirtualUser::getId).collect(Collectors.toList()));
        return list.stream().map(e -> {
            ChatVirtualUserDTO cv = new ChatVirtualUserDTO();
            BeanUtils.copyProperties((Object)e, (Object)cv);
            cv.setUnReplyNum(this.getUnReplyNum((AdminVirtualUserDTO)e));
            cv.setRecentTime((Date)recentTimeMap.get(e.getId()));
            return cv;
        }).limit(100L).sorted().collect(Collectors.toList());
    }

    private Map<Long, Date> getRecentTime(List<Long> userIds) {
        List allVirtureUserVos = this.imMapper.selectLastTimeByUserIds(userIds);
        Map<Long, Date> collect = allVirtureUserVos.stream().collect(Collectors.toMap(AllVirtureUserVo::getUserId, AllVirtureUserVo::getMaxTime));
        return collect;
    }

    @Override
    public List<User> getUserByKeyWord(String keyWord) {
        return this.userMapper.getUserByKeyWord(keyWord);
    }

    private Integer getUnReplyNum(AdminVirtualUserDTO adminVirtualUserDTO) {
        KeyGenerator unReplyNumKey = RedisConfig.VIRTURE_USER_UNREPLY.copy().appendKey((Object)adminVirtualUserDTO.getId());
        Map entries = this.redisHashMapAdapter.entries(unReplyNumKey, Integer.class);
        Collection values = entries.values();
        int sum = values.stream().mapToInt(Integer::intValue).sum();
        return sum;
    }

    private String getSex(Byte sex) {
        String sexStr = "\u7537";
        if (null != sex && 1 == sex) {
            sexStr = "\u7537";
        } else if (null != sex && 2 == sex) {
            sexStr = "\u5973";
        }
        return sexStr;
    }

    private String getUserInfo(String userInfo, String remark) {
        if (StringUtils.isEmpty((CharSequence)remark)) {
            return userInfo + ")";
        }
        return userInfo + " " + remark + ")";
    }
}

